﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts.Report;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LQKJ.K3.ENG.BOMSelect.ServersPlugIn
{
    [Description("钯价变动分析表"), HotUpdate]
    public class BaJiaServerPlugin: SysReportBaseService
    {
		private int Year = 0;
		public override void Initialize()
		{
			base.Initialize();
			this.ReportProperty.ReportName = new LocaleValue("钯价变动分析表", base.Context.UserLocale.LCID);
			ReportProperty.ReportType = ReportType.REPORTTYPE_NORMAL;
			this.ReportProperty.IsUIDesignerColumns = false;
			this.ReportProperty.PrimaryKeyFieldName = "FID";
			base.Initialize();
		}
		public override string GetTableName()
		{
			return base.GetTableName();
		}

		public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
		{
			string seqFld = string.Format(base.KSQL_SEQ, " T.FID ");
			DynamicObject dyFilter = filter.FilterParameter.CustomFilter;
			var keySet = dyFilter.DynamicObjectType.Properties;//过滤框的所有属性
			string sql = string.Format(@"/*dialect*/
												SELECT *,{0} into {1} FROM (
												select  D.FNAME,C.FDATAVALUE,A.FID,FMONTH,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='01'THEN FAREA ELSE 0 END)  AS FAREA1,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='01'THEN FPRICE ELSE 0 END)  AS FPRICE1,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='02'THEN FAREA ELSE 0 END)  AS FAREA2,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='02'THEN FPRICE ELSE 0 END)  AS FPRICE2,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='03'THEN FAREA ELSE 0 END)  AS FAREA3,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='03'THEN FPRICE ELSE 0 END)  AS FPRICE3,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='04'THEN FAREA ELSE 0 END)  AS FAREA4,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='04'THEN FPRICE ELSE 0 END)  AS FPRICE4,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='05'THEN FAREA ELSE 0 END)  AS FAREA5,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='05'THEN FPRICE ELSE 0 END)  AS FPRICE5,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='06'THEN FAREA ELSE 0 END)  AS FAREA6,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='06'THEN FPRICE ELSE 0 END)  AS FPRICE6,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='07'THEN FAREA ELSE 0 END)  AS FAREA7,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='07'THEN FPRICE ELSE 0 END)  AS FPRICE7,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='08'THEN FAREA ELSE 0 END)  AS FAREA8,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='08'THEN FPRICE ELSE 0 END)  AS FPRICE8,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='09'THEN FAREA ELSE 0 END)  AS FAREA9,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='09'THEN FPRICE ELSE 0 END)  AS FPRICE9,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='10'THEN FAREA ELSE 0 END)  AS FAREA10,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='10'THEN FPRICE ELSE 0 END)  AS FPRICE10,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='11'THEN FAREA ELSE 0 END)  AS FAREA11,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='11'THEN FPRICE ELSE 0 END)  AS FPRICE11,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='12'THEN FAREA ELSE 0 END)  AS FAREA12,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='12'THEN FPRICE ELSE 0 END)  AS FPRICE12,
												(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)=SUBSTRING(FORMAT(GetDate(),'yyyyMM'),5,2)THEN FPRICE ELSE 0 END)-SUM(CASE WHEN FMONTH=CONVERT(INT,FORMAT(GetDate(),'yyyyMM'))-1 THEN FPRICE ELSE 0 END))  AS FPRICESUB,
												SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)=SUBSTRING(FORMAT(GetDate(),'yyyyMM'),5,2)THEN FPRICE ELSE 0 END)*SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)=SUBSTRING(FORMAT(GetDate(),'yyyyMM'),5,2)THEN FAREA ELSE 0 END)-
												SUM(CASE WHEN FMONTH=CONVERT(INT,FORMAT(GetDate(),'yyyyMM'))-1 THEN FPRICE ELSE 0 END)*SUM(CASE WHEN FMONTH=CONVERT(INT,FORMAT(GetDate(),'yyyyMM'))-1 THEN FAREA ELSE 0 END) AS PRICECHANGE
												from ZTW_StockBill A left join ztw_StockBillItem  B ON A.FID=B.FEntryID left join T_BAS_ASSISTANTDATAENTRY_L C ON B.FITEMTYPE=C.FENTRYID
												left join T_BD_CUSTOMER_L D ON A.FCUSTOMERID=D.FCUSTID and D.FLOCALEID=2052
												group by A.FID,D.FNAME,C.FDATAVALUE,FMONTH ) T
													where 1=1
														", seqFld, tableName);//表名
			string FDate = dyFilter["F_LQKJ_FDATE"].ToString() == null ? "" : dyFilter["F_LQKJ_FDATE"].ToString();
			Year = Convert.ToInt32(FDate);
			DynamicObject ProductsName = dyFilter["F_LQKJ_FItem"] as DynamicObject;
			string Name = ProductsName["FDataValue"].ToString();
			if (!string.IsNullOrWhiteSpace(FDate))
			{
				sql += string.Format("AND substring(convert(nvarchar(20),T.FMONTH),1,4)='{0}'", FDate);

			}
			if (!string.IsNullOrWhiteSpace(Name))
			{
				sql += string.Format(" " + "AND T.FDATAVALUE='{0}'", Name);
			}

			DBUtils.ExecuteDynamicObject(this.Context, sql);
			base.BuilderReportSqlAndTempTable(filter, tableName);
		}
		public override ReportHeader GetReportHeaders(IRptParams filter)
		{
			//return base.GetReportHeaders(filter);
			ReportHeader header = new ReportHeader();
			var fname = header.AddChild("FNAME", new LocaleValue("客户名"));
			fname.ColIndex = 0;
			int month = 1;
			if (Year < DateTime.Now.Year)//小于当前年
			{
				month = 12;
			}
			else if (Year == DateTime.Now.Year)//等于当前年
			{
				month = DateTime.Now.Month;
			}
			int i = 1;
			for (; i <= month; i++)//选择年份来判断显示几个月
			{
				header.AddChild("FAREA" + i.ToString(), new LocaleValue(i.ToString() + "月面积")).ColIndex = i;
				header.AddChild("FPRICE" + i.ToString(), new LocaleValue(i.ToString() + "月单价")).ColIndex = i;
			}
			var priceSub = header.AddChild("FPRICESUB", new LocaleValue("单价差异"));
			var priceChange = header.AddChild("PRICECHANGE", new LocaleValue("变动金额"));
			return header;
		}
		//数据列汇总
		public override List<SummaryField> GetSummaryColumnInfo(IRptParams filter)
		{
			var result = base.GetSummaryColumnInfo(filter);
			for (int i = 1; i <= DateTime.Now.Month; i++)
			{
				result.Add(new SummaryField("FAREA" + i.ToString(), Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));
				result.Add(new SummaryField("FPRICE" + i.ToString(), Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));
			}
			return result;
		}

		protected override string GetIdentityFieldIndexSQL(string tableName)
		{
			string result = base.GetIdentityFieldIndexSQL(tableName);
			return result;
		}
		protected override void ExecuteBatch(List<string> listSql)
		{
			base.ExecuteBatch(listSql);
		}

		protected override void AfterCreateTempTable(string tablename)
		{
			base.AfterCreateTempTable(tablename);
		}
	}
}
