﻿using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.KDThread;
using Kingdee.BOS.Log;
using LQKJ.WebApi.Stub;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading;

namespace LQKJ.K3.MES.BusinessPlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("同步数据列表插件")]
    public class SyncProcessPlugin : AbstractListPlugIn
    {
        public override void BeforeDoOperation(BeforeDoOperationEventArgs e)
        {
            if (e.Operation.FormOperation.Operation == "SyncData")
            {
                HashSet<String> primaryKeyValues = new HashSet<string>();
                foreach(ListSelectedRow listSelectedRow in this.ListView.SelectedRowsInfo)
                {
                    primaryKeyValues.Add(listSelectedRow.PrimaryKeyValue);
                }

                if (primaryKeyValues.Count > 10)
                {
                    if (syncFlag) return;
                    e.Cancel = true;

                    this.View.ShowProcessForm(formResult => { }, true, "同步数据");


                    // 启动线程执行耗时操作，同时更新执行进度
                    MainWorker.QuequeTask(this.View.Context, () =>
                    {
                        try
                        {
                            this.View.Session["ProcessRateValue"] = 0;
                            DoOpSync();
                        }
                        catch (Exception ex)
                        {
                            this.View.ShowErrMessage(ex.Message);
                        }
                        finally
                        {

                            // 此句必不可少，进度值100时进度条自动关闭
                            this.View.Session["ProcessRateValue"] = 100;
                            this.View.SendDynamicFormAction(this.View);
                        }

                    }, null);


                    MainWorker.QuequeTask(this.View.Context, () =>
                    {
                        int allRecordsCount = SyncStaticParam.RecordIds.Count;
                        while (true)
                        {
                            if (SyncStaticParam.RecordIds.Count == 0)
                            {
                                System.Threading.Thread.Sleep(1000);
                                continue;
                            }
                            allRecordsCount = SyncStaticParam.RecordIds.Count;
                            int leftRecordCount = GetLeftRecordCount();
                            if (leftRecordCount == 0)
                            {
                                break;
                            }
                            
                            int process = ((allRecordsCount - leftRecordCount) * 100) / allRecordsCount;

                            if (process == 100)
                            {
                                process = 99;
                            }

                            this.View.Session["ProcessRateValue"] = process;
                            this.View.Session["ProcessTips"] = string.Format("一共{0}条记录，已处理{1}条记录", allRecordsCount, allRecordsCount - leftRecordCount);

                            System.Threading.Thread.Sleep(1000);
                        }

                    }, null);
                }
            }
            base.BeforeDoOperation(e);
        }


        /**
         * 已经同步完成
         */
        private int GetLeftRecordCount()
        {
            List<string> recordIds = SyncStaticParam.RecordIds;
            int leftRecordCount = 0;
            foreach (string recordId in recordIds)
            {
                if (!SyncStaticParam.DCSyncResultDic.ContainsKey(recordId))
                {
                    leftRecordCount ++;
                }
            }
            return leftRecordCount;
        }

        /**
         * 同步标识
         */
        private static bool syncFlag = false;

        /**
         * 同步数据
         * 
         */
        private void DoOpSync()
        {
            syncFlag = true;
            this.View.InvokeFormOperation("SyncData");
            syncFlag = false;
        }
    }
}
