﻿using Kingdee.BOS.Log;
using Kingdee.BOS.ServiceFacade.KDServiceFx;
using Kingdee.BOS.WebApi.Client;
using LQKJ.WebApi.Stub;
using Newtonsoft.Json.Linq;
using NPOI.SS.UserModel;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace LQKJ.K3.FileSystem.WebApi
{
    public class WebApiService : CustomWebApiService
    {
        private readonly CustomWebApiService obj = null;
        static object lockObject = new object();
        public WebApiService(KDServiceContext context) : base(context)
        {
            obj = new CustomWebApiService(context);
        }
        public ApiResult SelectDateTime(string typeO)
        {
            Dictionary<string, List<DateModel>> keyValuePairs = new Dictionary<string, List<DateModel>>();
            //string sqlSelect = $@"/*dialect*/ select  FID,FTYPE ,format(FTIMEPERIOD,'yyyy-MM-dd') [Date],
            //                       format(F_LQKJ_TIME,'HH:mm')+'-'+format(F_LQKJ_TIME1,'HH:mm')[time],FREMAINDERNUMBER,
            //                       case when format(F_LQKJ_TIME,'HH:mm:ss')<'12:00:00' then 0 else 1 end [type],
            //                           case DATEPART(WEEKDAY, FTIMEPERIOD)WHEN 1 THEN '休息'
            //                                   WHEN 2 THEN '周一'
            //                                   WHEN 3 THEN '周二'
            //                                   WHEN 4 THEN '周三'
            //                                   WHEN 5 THEN '周四'
            //                                   WHEN 6 THEN '周五'
            //                                   WHEN 7 THEN '周六'
            //                               END AS WeekdayName from LQKJ_t_AppointmentRules
            //                           where FTYPE='{typeO}' and  FDOCUMENTSTATUS = 'C' and FFORBIDSTATUS = 'A' 
            //and FTIMEPERIOD between format(getdate(),'yyyy-MM-dd') and format(DATEADD(DAY,6,getdate()),'yyyy-MM-dd') ";
            string sqlSelect = $@"exec DateSelect @Type='{typeO}'";
            DataSet dataSet = (DataSet)(obj.ExecutDataSet(sqlSelect).data);
            if (dataSet.Tables != null && dataSet.Tables[1].Rows.Count > 0)
            {
                DataTable dataTable = dataSet.Tables[0];
                DataTable data = dataSet.Tables[1];

                var datalist2 = data.AsEnumerable().Select(e => new
                {
                    FID = e.Field<Int64>("FID"),
                    time = e.Field<string>("time"),
                    FREMAINDERNUMBER = e.Field<Decimal>("FREMAINDERNUMBER"),
                    type = e.Field<int>("type"),
                    WeekdayName = e.Field<string>("WeekdayName")
                });
                var dataList = dataTable.AsEnumerable().Select(e => new
                {
                    Date = e.Field<string>("Date"),
                    FISRESTDAYS = e.Field<string>("FISRESTDAYS"),
                    WeekdayName = e.Field<string>("WeekdayName"),
                    data = datalist2.Where(m => m.WeekdayName == e.Field<string>("WeekdayName")).ToList()
                });
                //for (int i = 0; i < data.Rows.Count; i++)
                //{
                //    DateModel model = new DateModel
                //    {
                //        FID = int.Parse(data.Rows[i].ItemArray[0].ToString()),
                //        time = data.Rows[i].ItemArray[1].ToString(),
                //        FREMAINDERNUMBER = Convert.ToDecimal(data.Rows[i].ItemArray[2].ToString()),
                //        type = int.Parse(data.Rows[i].ItemArray[3].ToString()),
                //        WeekdayName = data.Rows[i].ItemArray[4].ToString()
                //    };
                //    var Key = data.Rows[i]["WeekdayName"].ToString();
                //    if (keyValuePairs.ContainsKey(Key))
                //    {
                //        keyValuePairs[Key].Add(model);
                //    }
                //    else
                //    {
                //        List<DateModel> dataRows = new List<DateModel>() { model };
                //        keyValuePairs.Add(Key, dataRows);
                //    }
                //}

                //var datalist = dataTable.AsEnumerable().Select(e => new
                //{
                //    Date=e.Field<string>("Date"),
                //    WeekdayName=e.Field<string>("WeekdayName"),
                //    data = keyValuePairs.AsEnumerable().Where(m => m.Key == e.Field<string>("WeekdayName")).Select(t => new
                //    {
                //        t.Value
                //    })
                //});
                return ApiResultHelper.Success(dataList, "查询成功");
            }
            //if (data.Rows.Count > 0)
            //{
            //    for (int i = 0; i < data.Rows.Count; i++)
            //    {
            //        DateModel model = new DateModel
            //        {
            //            FID = int.Parse(data.Rows[i].ItemArray[0].ToString()),
            //            FTYPE = data.Rows[i].ItemArray[1].ToString(),
            //            Date = data.Rows[i].ItemArray[2].ToString(),
            //            time = data.Rows[i].ItemArray[3].ToString(),
            //            FREMAINDERNUMBER = Convert.ToDecimal(data.Rows[i].ItemArray[4].ToString()),
            //            type = int.Parse(data.Rows[i].ItemArray[5].ToString()),
            //            WeekdayName = data.Rows[i].ItemArray[6].ToString()
            //        };
            //        var Key = data.Rows[i]["WeekdayName"].ToString();
            //        if (keyValuePairs.ContainsKey(Key))
            //        {
            //            keyValuePairs[Key].Add(model);
            //        }
            //        else
            //        {
            //            List<DateModel> dataRows = new List<DateModel>() { model };
            //            keyValuePairs.Add(Key, dataRows);
            //        }
            //    }
            //    return ApiResultHelper.Success(keyValuePairs, "查询成功");
            //}
            else
            {
                return ApiResultHelper.Error("没有任何数据");
            }
        }
        //查询是否已经有预约
        //public ApiResult SelectMsg(int type, string parmeters)
        //{
        //    var msg = JObject.Parse(parmeters);
        //    var Fid=msg["FId"]
        //    string sqlSelect = $"/*dialect*/ select format(FTIMEPERIOD,'yyyy-MM-dd')+' '+format(F_LQKJ_TIME,'HH:mm')+'-'+format(F_LQKJ_TIME1,'HH:mm') [Date] from LQKJ_t_AppointmentRules where FID={FId}";
        //    DataTable dataTable = obj.ExecuteDataTable(sqlSelect);
        //    string date = dataTable.Rows[0][0].ToString();
        //    switch (type)
        //    {
        //        case 0://个人查阅
        //            string FidCard = msg["Model"]["FIDCard"].ToString();
        //            sqlSelect = $"select * from T_DA_ArchiveAccess where FIDCARD='{FidCard}' and FDAIDCARD='{FidCard}' and FDATETIME1='{date}' and FREFERTOTYPE=0";
        //            break;
        //        case 1://他人查阅
        //            break;
        //        case 2://移交查询
        //            break;
        //    }
        //}
        //档案移交预约
        public ApiResult Add(string parmeters)
        {
            try
            {
                var msg = JObject.Parse(parmeters);
                K3CloudApiClient Client = apiClient();
                var result = JObject.Parse(Client.Save("LQKJ_ArchiveTransfer", msg.ToString()));
                var Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                if ((bool)Sueccess)//添加成功
                {
                    var Id = result["Result"]["ResponseStatus"]["SuccessEntitys"][0]["Id"].ToString();
                    var FBillNo = result["Result"]["ResponseStatus"]["SuccessEntitys"][0]["Number"].ToString();
                    //Client.Submit("LQKJ_ArchiveTransfer", "{\"Ids\":" + Id + "}");
                    //Client.Audit("LQKJ_ArchiveTransfer", "{\"Ids\":" + Id + "}");
                    JProperty property1 = new JProperty("Id", Id);
                    JProperty property2 = new JProperty("FBillNo", FBillNo);

                    var Model = JObject.Parse(msg["Model"].ToString());
                    Model.Add(property1); Model.Add(property2);
                    return ApiResultHelper.Success(Model, "预约成功");
                }
                else
                {
                    var ErrorMsg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                    return ApiResultHelper.Error(ErrorMsg);
                }
            }
            catch (Exception ex)
            {
                Logger.Error("ActionName:Add", ex.Message, ex);
            }
            return ApiResultHelper.Error("代码执行出错");
        }
        /// <summary>
        /// 附件上传
        /// </summary>
        /// <returns></returns>
        public ApiResult Uploda()
        {
            lock (lockObject)
            {
                HttpRequest request = HttpContext.Current.Request;
                //var Id = request.Form["Id"].ToString();
                //var FBillNo = request.Form["FBillNo"];
                var FId = request.Form["fid"].ToString();
                var File = request.Files["file"];
                var FileName = File.FileName;
                var Type = request.Form["type"].ToString();
                var parmeters = JObject.Parse(request.Form["parmeters"]);
                string sqlSelect = $"/*dialect*/ select format(FTIMEPERIOD,'yyyy-MM-dd')+' '+format(F_LQKJ_TIME,'HH:mm')+'-'+format(F_LQKJ_TIME1,'HH:mm') [Date],FREMAINDERNUMBER,format(FTIMEPERIOD,'yyyy-MM-dd')+' '+format(F_LQKJ_TIME1,'HH:mm') as MaxDate from LQKJ_t_AppointmentRules where FID={FId}";
                
                DataTable dataTable = obj.ExecuteDataTable(sqlSelect);
                DateTime dateTime = Convert.ToDateTime(dataTable.Rows[0][2].ToString());
                if (dateTime < DateTime.Now)
                {
                    return ApiResultHelper.Error("预约时间已过");
                }
                if (Type.Equals("0"))
                {
                    var fid = parmeters["Model"]["FIDCard"].ToString();
                    var dw = parmeters["Model"]["FUnitName"].ToString();
                    var date = dataTable.Rows[0][0].ToString();
                    sqlSelect = $"select FID from T_DA_ArchiveTransfer where FIDCARD='{fid}' and FDATETIME1='{date}' and FUNITNAME='{dw}'";
                    if (obj.ExecuteDataTable(sqlSelect).Rows.Count > 0)
                    {
                        return ApiResultHelper.Error402("您已经预约过，是否继续？");
                    }
                }
                Stream stream = File.InputStream;
                byte[] bytes = new byte[stream.Length];
                stream.Read(bytes, 0, bytes.Length);
                string Base64string = Convert.ToBase64String(bytes);
                IWorkbook workbook = WorkbookFactory.Create(stream);
                ISheet sheet = workbook.GetSheetAt(0);
                IRow Row0 = sheet.GetRow(0);//第一行
                string Title = Row0.GetCell(0).ToString().Replace(" ", "");
                if (Title != "南山区国有企业退休人员移交人事档案名单汇总表")
                    return ApiResultHelper.Error("文件首行标题有误，请修改");
                IRow Row1 = sheet.GetRow(1);//第二行
                Dictionary<int, string> keyValues = new Dictionary<int, string>();
                keyValues.Add(0, "序号");
                keyValues.Add(1, "所属集团");
                keyValues.Add(2, "移交企业");
                keyValues.Add(3, "移交地属地");
                keyValues.Add(4, "");
                keyValues.Add(5, "姓名");
                keyValues.Add(6, "性别");
                keyValues.Add(7, "身份证号");
                keyValues.Add(8, "个人联系电话");
                keyValues.Add(9, "是否中共党员");
                keyValues.Add(10, "党组织关系所在地");
                keyValues.Add(11, "备注");
                keyValues.Add(12, "国有企业性质");
                foreach (var item in keyValues)
                {
                    var Value = Row1.GetCell(item.Key).ToString().Replace(" ", "");
                    if (Value != item.Value)
                        return ApiResultHelper.Error($"文件第二行标题内容:{Value}有误，请修改");
                }
                IRow Row8 = sheet.GetRow(2);//第三行
                var Jd = Row8.GetCell(3).ToString().Replace(" ", "");
                if (Jd != "街道")
                {
                    return ApiResultHelper.Error($"文件第二行标题内容:{Jd}有误，请修改");
                }
                var Sq = Row8.GetCell(4).ToString().Replace(" ", "");
                if (Sq != "社区")
                {
                    return ApiResultHelper.Error($"文件第二行标题内容:{Sq}有误，请修改");
                }
                IRow Row5 = sheet.GetRow(sheet.LastRowNum - 2);//盖章
                var Gz = Row5.GetCell(2).ToString().TrimEnd();
                var Gz1 = Gz.Substring(Gz.Length - 10);
                if (Gz1 != "集团/公司 （盖章）")
                {
                    return ApiResultHelper.Error($"文件第{sheet.LastRowNum - 2}行标题内容:{Gz}有误，请修改");
                }
                var Gz3 = Row5.GetCell(8).ToString().TrimEnd();
                if (!Gz3.Contains("街道") || !Gz3.Contains("社区工作站（盖章）"))
                {
                    return ApiResultHelper.Error($"文件第{sheet.LastRowNum - 2}行标题内容:{Gz3}有误，请修改");
                }
                var Row6 = sheet.GetRow(sheet.LastRowNum - 1);
                var Jbr = Row6.GetCell(2).ToString().TrimStart();
                var JbrName1 = Jbr.Substring(Jbr.IndexOf("：") == -1 ? Jbr.IndexOf(":") : Jbr.IndexOf("："));
                var Jbr2 = Jbr.Substring(0, 8);
                if (Jbr2 != "经办人（签字）：")
                {
                    return ApiResultHelper.Error($"文件第{sheet.LastRowNum - 1}行标题内容:{Jbr}有误，请修改");
                }
                Jbr = Row6.GetCell(8).ToString().TrimStart();
                var JbrName2 = Jbr.Substring(Jbr.IndexOf("：") == -1 ? Jbr.IndexOf(":") : Jbr.IndexOf("："));
                Jbr2 = Jbr.Substring(0, 8);
                if (Jbr2 != "经办人（签字）：")
                {
                    return ApiResultHelper.Error($"文件第{sheet.LastRowNum - 1}行标题内容:{Jbr}有误，请修改");
                }
                var Row7 = sheet.GetRow(sheet.LastRowNum);
                var dt1 = Row7.GetCell(2).ToString().Replace(" ", "");
                var dt2 = Row7.GetCell(8).ToString().Replace(" ", "");
                try
                {
                    Convert.ToDateTime(dt1);
                    Convert.ToDateTime(dt2);
                }
                catch (Exception)
                {
                    return ApiResultHelper.Error($"文件第{sheet.LastRowNum }行日期有误，请修改");
                }
                int sum = 0;
                for (int i = 3; i < sheet.LastRowNum - 7; i++)
                {
                    IRow row = sheet.GetRow(i);
                    if (row.GetCell(0).ToString() == "")
                    {
                        return ApiResultHelper.Error($"文件第{i}行序号有误，请修改");
                    }
                    sum += 1;
                }
                if (sum > 20)
                {
                    return ApiResultHelper.Error($"档案资料不允许超过20条！");
                }
                stream.Dispose();
                //全部都通过了
                K3CloudApiClient Client = apiClient();
                
                if (dataTable.Rows[0][1].ToString().Equals("0"))
                {
                    return ApiResultHelper.Error("名额已满");
                }
                string Date = dataTable.Rows[0][0].ToString();
                parmeters["Model"]["FDatetime"] = Date;
                var result = JObject.Parse(Client.Save("LQKJ_ArchiveTransfer", parmeters.ToString()));
                var Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                if (!(bool)Sueccess)
                {
                    var ErrorMsg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                    return ApiResultHelper.Error(ErrorMsg);
                }
                sqlSelect = $"update LQKJ_t_AppointmentRules set FREMAINDERNUMBER=FREMAINDERNUMBER-1,FAPPOINTMENTQTY=FAPPOINTMENTQTY+1 where FID ={FId} ";
                obj.Execute(sqlSelect);
                var Phone = parmeters["Model"]["FPhoneNumber"].ToString();
                var Id = result["Result"]["ResponseStatus"]["SuccessEntitys"][0]["Id"].ToString();
                var FBillNo = result["Result"]["ResponseStatus"]["SuccessEntitys"][0]["Number"].ToString();
                StringBuilder stringBuilder = new StringBuilder();
                string header = "{\"IsDeleteEntry\": \"false\",\"Model\": {\"FID\": " + Id + ",\"F_LQKJ_ProfileInfoEntity\": [";
                stringBuilder.Append(header);
                string context = "";
                for (int i = 3; i < sheet.LastRowNum - 7; i++)
                {
                    IRow row = sheet.GetRow(i);
                    var Jt = row.GetCell(1).ToString();//所属集团
                    var Qy = row.GetCell(2).ToString();//移交企业
                    var Jd1 = row.GetCell(3).ToString();//街道
                    var Sq1 = row.GetCell(4).ToString();//社区
                    var Sm = row.GetCell(5).ToString();//姓名
                    var Xb = row.GetCell(6).ToString() == "男" ? 0 : 1;//性别
                    var Sfz = row.GetCell(7).ToString();//身份证号
                    var Dh = row.GetCell(8).ToString();//电话
                    var Dy = row.GetCell(9).ToString() == "" ? false : row.GetCell(9).ToString() == "否" ? false : true;//是否党员
                    var Zj = row.GetCell(10).ToString();//党组织
                    var Bz = row.GetCell(11).ToString();//备注
                    var Xz = row.GetCell(12).ToString();//性质
                    context = "{\"FGroupAffiliation\": \"" + Jt + "\",\"FhandedOverCompanies\": \"" + Qy + "\",\"FStreet\": \"" + Jd1 + "\",\"FCommunity\": \"" + Sq1 + "\",\"FName\": \"" + Sm + "\",\"FIDCards\": \"" + Sfz + "\",\"FSex\": \"" + Xb + "\",\"FPhone\": \"" + Dh + "\",\"FISParty\": \"" + Dy + "\",\"FPartyLocation\": \"" + Zj + "\",\"FRemark\": \"" + Bz + "\",\"FEnterpriseQuality\": \"" + Xz + "\"},";
                    stringBuilder.Append(context);
                }
                string last = "]}}";
                stringBuilder.Append(last);
                result = JObject.Parse(Client.Save("LQKJ_ArchiveTransfer", stringBuilder.ToString()));
                Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                if (!(bool)Sueccess)
                {
                    var msg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                    return ApiResultHelper.Error(msg);
                }
                string Json = "{\"FileName\":\"" + FileName + "\",\"FormId\":\"LQKJ_ArchiveTransfer\",\"IsLast\":\"true\",\"InterId\":\"" + Id + "\",\"BillNO\":\"" + FBillNo + "\",\"SendByte\":\"" + Base64string + "\"}";
                result = JObject.Parse(Client.AttachmentUpload(Json));
                Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                if ((bool)Sueccess)
                {
                    Verification(Phone, "【灵清科技】您好！您已预约成功（xx月xx日xx点）到西部人力办理档案业务。请携带相关证件、材料按时到场。如未能到场请提前1天取消预约，超时未到场号源将自动失效，请重新预约。");
                    return ApiResultHelper.Success(JObject.Parse(Json)["FileName"].ToString(), "上传成功");
                }
                else //别看了，很简单的
                {
                    var msg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                    return ApiResultHelper.Error(msg);
                }
            }
        }
        public ApiResult Select(string parmeters)
        {
            lock (lockObject)
            {
                var msg = JObject.Parse(parmeters);
                var FId = msg["Fid"].ToString();
                msg.Remove("Fid");
                string sqlSelect = $"/*dialect*/ select format(FTIMEPERIOD,'yyyy-MM-dd')+' '+format(F_LQKJ_TIME,'HH:mm')+'-'+format(F_LQKJ_TIME1,'HH:mm') [Date],FREMAINDERNUMBER,format(FTIMEPERIOD,'yyyy-MM-dd')+' '+format(F_LQKJ_TIME1,'HH:mm') as MaxDate from LQKJ_t_AppointmentRules where FID={FId}";
                DataTable dataTable = obj.ExecuteDataTable(sqlSelect);
                DateTime dateTime = Convert.ToDateTime(dataTable.Rows[0][2].ToString());
                if (dateTime < DateTime.Now)
                {
                    return ApiResultHelper.Error("预约时间已过");
                }
                msg["Model"]["FDatetime"] = dataTable.Rows[0][0].ToString();
                K3CloudApiClient Client = apiClient();
                var Count = msg["Model"]["FReservationQty"].ToString();
                var Type = msg["Model"]["FReferToType"].ToString();
                if (Type.Equals("0"))//个人查阅
                {
                    var FidCard = msg["Model"]["FIDCard"].ToString();
                    sqlSelect = $"select FID from T_DA_ArchiveAccess where FIDCARD='{FidCard}' and FREFERTOTYPE=0 and FDAIDCARD='{FidCard}'  and FDATETIME1='{dataTable.Rows[0][0].ToString()}'";
                    if ( obj.ExecuteDataTable(sqlSelect).Rows.Count > 0)
                    {
                        return ApiResultHelper.Error402("您已经预约过，请勿重复预约！");
                    }
                    JObject.Parse(msg["Model"].ToString()).Remove("FDAName1");
                    JObject.Parse(msg["Model"].ToString()).Remove("FDAIDCard1");
                    msg["Model"]["FAppointedBy"] = msg["Model"]["FDAName"];
                    msg["Model"]["FIDCard"] = msg["Model"]["FDAIDCard"];
                    //msg["Model"]["FIDCard"]=
                    var result = JObject.Parse(Client.Save("LQKJ_ArchiveAccess", msg.ToString()));
                    var Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                    if ((bool)Sueccess)
                    {
                        sqlSelect = $"update LQKJ_t_AppointmentRules set FREMAINDERNUMBER=FREMAINDERNUMBER-1,FAPPOINTMENTQTY=FAPPOINTMENTQTY+1 where FID ={FId} ";
                        obj.Execute(sqlSelect);
                        string phone = msg["Model"]["FPhoneNumber"].ToString();
                        var Mes = "【灵清科技】请您按预约时间到西部人力办理业务，如因未能按时抵达现场导致时间段内无法完成事项办理，请您重新预约。";
                        Verification(phone, Mes);
                        return ApiResultHelper.Success(msg, "操作成功");
                    }
                    else
                    {
                        var ErrorMsg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                        return ApiResultHelper.Error(ErrorMsg);
                    }
                }
                else//他人查阅
                {
                    if (Count.Equals("1"))//只有一份
                    {
                        var FidCard = msg["Model"]["FIDCard"].ToString();
                        var FidCard2 = msg["Model"]["FDAIDCard"].ToString();
                        sqlSelect = $"select FID from T_DA_ArchiveAccess where FIDCARD='{FidCard}' and FREFERTOTYPE=1 and FDAIDCARD='{FidCard2}'  and FDATETIME1='{dataTable.Rows[0][0].ToString()}'";
                        if ( obj.ExecuteDataTable(sqlSelect).Rows.Count > 0)
                        {
                            return ApiResultHelper.Error402("您已经预约过，请勿重复预约！");
                        }
                        JObject.Parse(msg["Model"].ToString()).Remove("FDAName1");
                        JObject.Parse(msg["Model"].ToString()).Remove("FDAIDCard1");
                        var result = JObject.Parse(Client.Save("LQKJ_ArchiveAccess", msg.ToString()));
                        var Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                        if ((bool)Sueccess)
                        {
                            sqlSelect = $"update LQKJ_t_AppointmentRules set FREMAINDERNUMBER=FREMAINDERNUMBER-1,FAPPOINTMENTQTY=FAPPOINTMENTQTY+1 where FID ={FId} ";
                            obj.Execute(sqlSelect);
                            string phone = msg["Model"]["FPhoneNumber"].ToString();
                            var Mes = "【灵清科技】请您按预约时间到西部人力办理业务，如因未能按时抵达现场导致时间段内无法完成事项办理，请您重新预约。";
                            Verification(phone, Mes);
                            return ApiResultHelper.Success(msg, "操作成功");
                        }
                        else
                        {
                            var ErrorMsg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                            return ApiResultHelper.Error(ErrorMsg);
                        }
                    }
                    else
                    {
                        var FidCard = msg["Model"]["FIDCard"].ToString();
                        var FidCard2 = msg["Model"]["FDAIDCard"].ToString();
                        var FidCard3 = msg["Model"]["FDAIDCard1"].ToString();
                        var sqlSelect1 = $"select FID from T_DA_ArchiveAccess where FIDCARD='{FidCard}' and FREFERTOTYPE=1 and FDAIDCARD='{FidCard2}'  and FDATETIME1='{dataTable.Rows[0][0].ToString()}'";
                        var sqlSelect2 = $"select FID from T_DA_ArchiveAccess where FIDCARD='{FidCard}' and FREFERTOTYPE=1 and FDAIDCARD='{FidCard3}'  and FDATETIME1='{dataTable.Rows[0][0].ToString()}'";
                        if (obj.ExecuteDataTable(sqlSelect1).Rows.Count > 0 || obj.ExecuteDataTable(sqlSelect2).Rows.Count>0)
                        {
                            return ApiResultHelper.Error402("您已经预约过，请勿重复预约！");
                        }
                        string FDAName1 = msg["Model"]["FDAName1"].ToString();
                        string FDAIDCard1 = msg["Model"]["FDAIDCard1"].ToString();
                        JObject.Parse(msg["Model"].ToString()).Remove("FDAName1");
                        JObject.Parse(msg["Model"].ToString()).Remove("FDAIDCard1");
                        var result = JObject.Parse(Client.Save("LQKJ_ArchiveAccess", msg.ToString()));
                        var Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                        if (!(bool)Sueccess)//第一次新增
                        {
                            var ErrorMsg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                            return ApiResultHelper.Error(ErrorMsg);
                        }
                        msg["Model"]["FDAName"] = FDAName1;
                        msg["Model"]["FDAIDCard"] = FDAIDCard1;
                        result = JObject.Parse(Client.Save("LQKJ_ArchiveAccess", msg.ToString()));
                        Sueccess = result["Result"]["ResponseStatus"]["IsSuccess"];
                        if ((bool)Sueccess)//第二次新增
                        {
                            sqlSelect = $"update LQKJ_t_AppointmentRules set FREMAINDERNUMBER=FREMAINDERNUMBER-1,FAPPOINTMENTQTY=FAPPOINTMENTQTY+1 where FID ={FId} ";
                            obj.Execute(sqlSelect);
                            string phone = msg["Model"]["FPhoneNumber"].ToString();
                            var Mes = "【灵清科技】请您按预约时间到西部人力办理业务，如因未能按时抵达现场导致时间段内无法完成事项办理，请您重新预约。";
                            Verification(phone, Mes);
                            return ApiResultHelper.Success(msg, "操作成功");

                        }
                        else
                        {
                            var ErrorMsg = (string)result["Result"]["ResponseStatus"]["Errors"][0]["Message"];
                            return ApiResultHelper.Error(ErrorMsg);
                        }
                    }

                }
            }
        }
        public bool Verification(string Phone, string msg)
        {
            string u = "18926482017";
            MD5 md5 = new MD5CryptoServiceProvider();
            byte[] fromData = Encoding.UTF8.GetBytes(u);
            byte[] targetData = md5.ComputeHash(fromData);
            string ApiKey = "7fda47dc16a84e8e8592fbc4b126d255";
            WebClient Client = new WebClient();
            Client.Credentials = CredentialCache.DefaultCredentials;
            string code = new Random().Next(1111, 9999).ToString();
            string content = HttpUtility.UrlEncode($"{msg}", Encoding.UTF8);//短信发送内容并进行 urlencode编码
            string Url = $"http://api.smsbao.com/sms?u={u}&p={ApiKey}&m={Phone}&c={content}";
            byte[] result = Client.DownloadData(Url);// 向远程网址发送请求并获取返回值保存至字节数组
            string sres = Encoding.UTF8.GetString(result); /*将返回结果转换成字符串*/
            switch (sres)
            {
                case "0":
                    {
                        return true;
                    }
            }
            return false;
        }
        public ApiResult Deposit(string name, string idCard)
        {
            string sql = $"select * from LQKJ_t_FilesManage where FIDCARD='{idCard}' and FNAME='{name}'";
            var result = obj.ExecuteDataTable(sql);
            if (result.Rows.Count > 0)
            {
                return ApiResultHelper.Success(null, "该档案已存放于西部人力，如有需要查阅，请于“档案查阅”界面进行预约。");
            }
            else
            {
                return ApiResultHelper.Error400("未查询到该人员信息，请核对信息输入是否正确（请勿输入空格），或与原档案保存单位核实情况。");
            }
        }
        private K3CloudApiClient apiClient()
        {
            K3CloudApiClient Client = new K3CloudApiClient(base.url);
            var loginResult = Client.ValidateLogin(base.dbid, base.username, base.password, 2052);
            var resultType = JObject.Parse(loginResult)["LoginResultType"].Value<int>();
            if (resultType == 1)
            {
                return Client;
            }
            throw new Exception("登陆失败");
        }
    }
}
