﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace LQKJ.K3.MES.AppServicePlugin
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("分录同步数据服务插件")]
    public class SyncdataEntityService : AbstractOperationServicePlugIn
    {
        
        public override void BeginOperationTransaction(BeginOperationTransactionArgs e)
        {

        }
        public override void EndOperationTransaction(EndOperationTransactionArgs e)
        {
            List<string> list = new List<string>();
            string id = base.BusinessInfo.GetForm().Id;
            string text = base.Context.UserId.ToString();
            string text2 = base.FormOperation.OperationName.ToString();
            string operation = base.FormOperation.Operation;
            var pkIds = ((EndSetStatusTransactionArgs)e).PkEntryIds;
            HashSet<string> errorIds = new HashSet<string>();
            foreach (var error in this.OperationResult.ValidationErrors)
            {
                errorIds.Add(error.BillPKID);
            }

            //BillPKID
            foreach (var pkId in pkIds)
            {
                if (errorIds.Contains(pkId.Value.ToString())) continue;

                string item = string.Format("insert into LQKJ_t_IMSSync(FID,F_LQKJ_SYNCDATAID,F_LQKJ_SYNCBILL,F_LQKJ_SYNDDATETIME,FCREATORID,FMODIFIERID,FCREATEDATE,FMODIFYDATE,F_LQKJ_SYNCCHECK,F_LQKJ_Operationname,F_LQKJ_operationinnercode,F_LQKJ_SYNCDATAENTRYID)\r\n              values(NEWID(),'{0}','{1}',null,'{2}','0',GETDATE(),GETDATE(),'0','{3}','{4}','{5}')", new object[]
                {
                pkId.Key,
                id,
                text,
                text2,
                operation,
                pkId.Value
                });
                list.Add(item);
            }
            DBUtils.ExecuteBatch(base.Context, list, list.Count);
            base.EndOperationTransaction(e);
        }
        public override void AfterExecuteOperationTransaction(AfterExecuteOperationTransaction e)
        {
            base.AfterExecuteOperationTransaction(e);
        }

    }
}
