﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;
using Kingdee.BOS.Contracts;
using Kingdee.BOS;
using Kingdee.BOS.Core;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using Kingdee.BOS.WebApi.Client;
using Kingdee.BOS.WebApi.FormService;

namespace LQKJ.K3.FileSystem.BlacklistTimingPlugIN
{
    [Description("执行计划插件，档案自动移入黑名单"), HotUpdate]
    public class BlacklistTimingPlugIN : IScheduleService
    {
        public void Run(Context ctx, Schedule schedule)
        {
            DateTime Date;
            //Date = new DateTime(2023, 09, 12);
            Date = DateTime.Now;
            string sql = $"/*dialect*/ select DISTINCT FTRANSFERREDBY,FIDCARD from T_DA_ArchiveTransfer where LEFT(FDATETIME1,10)<='{Date.AddDays(-1).ToString("yyyy-MM-dd")}'and LEFT(FDATETIME1,10)>='{Date.AddDays(-8).ToString("yyyy-MM-dd")}' and FHANDLESTATES='N'and FForbidStatus='A'" ;
            //查询逾期今日所有逾期的数量预约
            DataTable TodayLateData = DBServiceHelper.ExecuteDataSet(ctx, sql).Tables[0];
            if (TodayLateData.Rows.Count <= 0)
                return;
            foreach (DataRow item in TodayLateData.Rows)
            {
                var FTRANSFERREDBY = item["FTRANSFERREDBY"].ToString();
                var FIDCARD = item["FIDCARD"].ToString();
                var UserId = ctx.UserId;
                string HmdYzSql = $"exec BlacklistVerification @FIDCARD='{FIDCARD}'";
                DataTable HmdYzData = DBServiceHelper.ExecuteDataSet(ctx, HmdYzSql).Tables[0];
                if(HmdYzData!=null&& HmdYzData.Rows!=null&& HmdYzData.Rows.Count > 0)
                {
                    if (HmdYzData.Rows[0][0].ToString() == "2")
                    {
                        //string json = $@"{{ ""NeedUpDateFields"": [],""NeedReturnFields"": [],""IsDeleteEntry"": ""true"",""SubSystemId"": """",""IsVerifyBaseDataField"": ""false"",""IsEntryBatchFill"": ""true"", ""ValidateFlag"": ""true"",""NumberSearch"": ""true"",""IsAutoAdjustField"": ""false"",""InterationFlags"": """",""IgnoreInterationFlag"": """",""IsControlPrecision"": ""false"",""ValidateRepeatJson"": ""false"",""Model"": {{""FBeOverdue"": {YuQiCountSum},""FRemarks"": """",""FCreatorId"": {{ ""FUserID"": ""{UserId.ToString()}""}},""FCreateDate"": ""{DateTime.Now.ToString("yyyy-MM-dd")}"",""FModifierId"": {{""FUserID"": """"}},""FModifyDate"": """",""FForbidderId"": {{""FUserID"": """"}},""FForbidDate"": """",""FNAME"": ""{FTRANSFERREDBY}"",""F_LQKJ_Combo"": ""2"",""F_LQKJ_Integer"": 0,""F_LQKJ_Text"": ""{FIDCARD}""}}}}";
                        string json = $@"{{ ""Model"": {{""FBeOverdue"": {HmdYzData.Rows[0][1].ToString()},""FRemarks"": """",""FCreatorId"": {{ ""FUserID"": ""{UserId.ToString()}""}},""FCreateDate"": ""{DateTime.Now.ToString("yyyy-MM-dd")}"",""FModifierId"": {{""FUserID"": """"}},""FModifyDate"": """",""FForbidderId"": {{""FUserID"": """"}},""FForbidDate"": """",""FNAME"": ""{FTRANSFERREDBY}"",""F_LQKJ_Combo"": ""2"",""F_LQKJ_Integer"": 0,""F_LQKJ_Text"": ""{FIDCARD}""}}}}";
                        var unAuditret = JsonUtil.Serialize(WebApiServiceCall.Save(ctx, "LQKJ_Blacklist", json.ToString()));
                        //JObject jobject = JObject.Parse(JsonConvert.SerializeObject(unAuditret));
                        bool IsunAudiSuccess = (bool)JObject.Parse(unAuditret.ToString())["Result"]["ResponseStatus"]["IsSuccess"];
                        if (!IsunAudiSuccess)
                        {
                            continue;
                        }
                    }
                }
            }
        }
    }
}
