﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;
using Kingdee.BOS.Contracts;
using Kingdee.BOS;
using Kingdee.BOS.Core;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System.Data;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json;
using Kingdee.BOS.WebApi.Client;
using System.Dynamic;
using Kingdee.BOS.WebApi.FormService;
using Kingdee.BOS.Log;

namespace LQKJ.K3.FileSystem.BlacklistTimingPlugIN
{
    public class ReservationRuleTimePlug : IScheduleService
    {
        public void Run(Context ctx, Schedule schedule)
        {
            DateTime dateTime = DateTime.Now;
            string SeSql = $"/*dialect*/select FID,FORMAT(FTIMEPERIOD,'yyyy-MM-dd')as date From LQKJ_t_AppointmentRules where FDOCUMENTSTATUS='C'and FFORBIDSTATUS='A' and year(FTIMEPERIOD)='{dateTime.Year}'";
            DateTime startDate = new DateTime(dateTime.Year, 1, 1);
            DateTime endDate = new DateTime(dateTime.Year, 12, 31);
            DataTable SeDt = DBServiceHelper.ExecuteDataSet(ctx, SeSql).Tables[0];//查询当前年份已有的数据
            var Dts = SeDt.AsEnumerable();
            StringBuilder stringBuilder = new StringBuilder();
            string header = "{\"IsDeleteEntry\": \"false\",\"IsAutoAdjustField\": \"true\",\"Model\":[";
            stringBuilder.Append(header);
            for (DateTime date = startDate; date <= endDate; date = date.AddDays(1))
            {
                if (Dts.Any(e => e.Field<string>("date") == date.ToString("yyyy-MM-dd")))//如果存在则跳过
                    continue;
                string CheckBoxRest;
                if (date.DayOfWeek == DayOfWeek.Saturday || date.DayOfWeek == DayOfWeek.Sunday)
                {
                    CheckBoxRest = "1";
                }
                else
                {
                    CheckBoxRest = "0";
                }
                DateTime StateTime = new DateTime(2023, 9, 26, 9, 30, 0);
                DateTime EndTime = new DateTime(2023, 9, 26, 16, 30, 0);
                List<RuleInformation> RuleInformationLisst = new List<RuleInformation>();    
                for (; StateTime <= EndTime; StateTime = StateTime.AddMinutes(60))
                {
                    if (StateTime.Hour == 11 || StateTime.Hour == 12 || StateTime.Hour == 13)
                        continue;
                    RuleInformationLisst.Add(new RuleInformation(CheckBoxRest, StateTime, StateTime.AddMinutes(60),1,1));
                }
                string json = JsonConvert.SerializeObject(RuleInformationLisst, Formatting.Indented);
                stringBuilder.Append("{\"FTimePeriod\":\"" + date + "\",\"FISRestDays\": \"" + CheckBoxRest + "\",\"FDateType\": \"" + CheckBoxRest + "\",\"F_LQKJ_RuleInfoRuleInformation\":" + json + " },");
                RuleInformationLisst.Clear();
            }
            stringBuilder.Append("]}");
            var unAuditret = JsonUtil.Serialize(WebApiServiceCall.BatchSave(ctx, "LQKJ_AppointmentRules", stringBuilder.ToString()));
            //JObject jobject = JObject.Parse(JsonConvert.SerializeObject(unAuditret));
            bool IsunAudiSuccess = (bool)JObject.Parse(unAuditret.ToString())["Result"]["ResponseStatus"]["IsSuccess"];
            if (!IsunAudiSuccess)
                 Logger.Info("ActionName:ReservationRuleTimePlug", unAuditret.ToString());
        }
    }
}
