﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.BusinessFlow.PlugIn;
using Kingdee.BOS.Core.BusinessFlow.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.MES.ServicePlugIn
{
    [Kingdee.BOS.Util.HotUpdate]
    [Description("业务关闭后同步分录数据反写插件")]
    public class CheckBusinessClosureRewriteService: AbstractBusinessFlowServicePlugIn
    {
        public static int index;
        public static int indexCount;
        public static int isSyncdataEnd;
        public override void AfterCloseRow(AfterCloseRowEventArgs e)
        {
            base.AfterCloseRow(e);
            var data = e.SourceDataObject;
            var org = base.Context.CurrentOrganizationInfo.ID.ToString();
            string sqlOrg = $@"/*dialect*/select F_LQKJ_CHECKBOX from LQKJ_t_SynchronizationSet where F_LQKJ_ORGID={org}";
            DataTable dtOrg = DBUtils.ExecuteDataSet(this.Context, sqlOrg).Tables[0];
            if (dtOrg.Rows.Count == 0) return;
            if (dtOrg.Rows[0]["F_LQKJ_CHECKBOX"].ToString() != "1") return;
            var sourdata = e.SourceEntity.DynamicObjectType.ToString();
            /**
             * 这个判断可以去掉，测试一下
             */
            if (sourdata == "PUR_ReceiveEntry" || sourdata == "POOrderEntry")
            {
                var pkIds = data[sourdata] as Kingdee.BOS.Orm.DataEntity.DynamicObjectCollection;
                var sourceEntry = e.SourceActiveRow["id"].ToString();
                index = pkIds.Count;
                List<string> list = new List<string>();
                string id = e.SourceBusinessInfo.Elements[0].Id;
                string text = base.Context.UserId.ToString();
                string text2 = "业务关闭";
                string operation = "MRPClose";
                if (e.BillCloseFieldStatus == "B" && e.BillOldCloseFieldStatus == "B" && e.EntryCloseFieldStatus == "B" && e.EntryOldCloseFieldStatus == "B") indexCount++; //所有物料关闭后
                if (e.BillCloseFieldStatus == "A" && e.BillOldCloseFieldStatus == "A" && e.EntryCloseFieldStatus == "B" && e.EntryOldCloseFieldStatus == "A")//单条物料下推或者多条物料下推的第一次条物料
                {
                    string item = insertSyncdata(data, id, text, text2, operation, sourceEntry);
                    DBUtils.Execute(base.Context, item);
                }
                if (e.BillCloseFieldStatus == "B" && e.BillOldCloseFieldStatus == "A" && e.EntryCloseFieldStatus == "B" && e.EntryOldCloseFieldStatus == "A") //最后一条物料关闭后
                {
                    string item = insertSyncdata(data, id, text, text2, operation, sourceEntry);
                    DBUtils.Execute(base.Context, item);
                    text2 = "整单业务关闭";
                    operation = "BillClose";
                    string item1 = insertSyncdata(data, id, text, text2, operation, "");
                    DBUtils.Execute(base.Context, item1);
                }
            }
        }

        private static string insertSyncdata(DynamicObject data, string id, string text, string text2, string operation, string entryID)
        {
            return string.Format("insert into LQKJ_t_IMSSync(FID,F_LQKJ_SYNCDATAID,F_LQKJ_SYNCBILL,F_LQKJ_SYNDDATETIME,FCREATORID,FMODIFIERID,FCREATEDATE,FMODIFYDATE,F_LQKJ_SYNCCHECK,F_LQKJ_Operationname,F_LQKJ_operationinnercode,F_LQKJ_SYNCDATAENTRYID)\r\n              values(NEWID(),'{0}','{1}',null,'{2}','0',GETDATE(),GETDATE(),'0','{3}','{4}','{5}')", new object[]
            {
                        data["id"],
                        id,
                        text,
                        text2,
                        operation,
                        entryID
            });
        }
    }
}
