/*
SQLyog Enterprise v13.1.1 (64 bit)
MySQL - 5.7.25 : Database - db_integrate
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`db_integrate` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `db_integrate`;

/*Table structure for table `qrtz_blob_triggers` */

DROP TABLE IF EXISTS `qrtz_blob_triggers`;

CREATE TABLE `qrtz_blob_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `BLOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_blob_triggers` */

/*Table structure for table `qrtz_calendars` */

DROP TABLE IF EXISTS `qrtz_calendars`;

CREATE TABLE `qrtz_calendars` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_calendars` */

/*Table structure for table `qrtz_cron_triggers` */

DROP TABLE IF EXISTS `qrtz_cron_triggers`;

CREATE TABLE `qrtz_cron_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `CRON_EXPRESSION` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TIME_ZONE_ID` varchar(80) COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_cron_triggers` */

/*Table structure for table `qrtz_fired_triggers` */

DROP TABLE IF EXISTS `qrtz_fired_triggers`;

CREATE TABLE `qrtz_fired_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `ENTRY_ID` varchar(95) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `FIRED_TIME` bigint(13) NOT NULL,
  `SCHED_TIME` bigint(13) NOT NULL,
  `PRIORITY` int(11) NOT NULL,
  `STATE` varchar(16) COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL,
  `JOB_GROUP` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_fired_triggers` */

/*Table structure for table `qrtz_job_details` */

DROP TABLE IF EXISTS `qrtz_job_details`;

CREATE TABLE `qrtz_job_details` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) COLLATE utf8mb4_bin DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) COLLATE utf8mb4_bin NOT NULL,
  `IS_DURABLE` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `IS_NONCONCURRENT` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `IS_UPDATE_DATA` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) COLLATE utf8mb4_bin NOT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_job_details` */

/*Table structure for table `qrtz_locks` */

DROP TABLE IF EXISTS `qrtz_locks`;

CREATE TABLE `qrtz_locks` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `LOCK_NAME` varchar(40) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_locks` */

insert  into `qrtz_locks`(`SCHED_NAME`,`LOCK_NAME`) values 
('DefaultQuartzScheduler','STATE_ACCESS'),
('DefaultQuartzScheduler','TRIGGER_ACCESS');

/*Table structure for table `qrtz_paused_trigger_grps` */

DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;

CREATE TABLE `qrtz_paused_trigger_grps` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_paused_trigger_grps` */

/*Table structure for table `qrtz_scheduler_state` */

DROP TABLE IF EXISTS `qrtz_scheduler_state`;

CREATE TABLE `qrtz_scheduler_state` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `LAST_CHECKIN_TIME` bigint(13) NOT NULL,
  `CHECKIN_INTERVAL` bigint(13) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_scheduler_state` */

insert  into `qrtz_scheduler_state`(`SCHED_NAME`,`INSTANCE_NAME`,`LAST_CHECKIN_TIME`,`CHECKIN_INTERVAL`) values 
('DefaultQuartzScheduler','LAPTOP-L53FL4S31666574001475',1666574088650,10000);

/*Table structure for table `qrtz_simple_triggers` */

DROP TABLE IF EXISTS `qrtz_simple_triggers`;

CREATE TABLE `qrtz_simple_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `REPEAT_COUNT` bigint(7) NOT NULL,
  `REPEAT_INTERVAL` bigint(12) NOT NULL,
  `TIMES_TRIGGERED` bigint(10) NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_simple_triggers` */

/*Table structure for table `qrtz_simprop_triggers` */

DROP TABLE IF EXISTS `qrtz_simprop_triggers`;

CREATE TABLE `qrtz_simprop_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `STR_PROP_1` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `STR_PROP_2` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `STR_PROP_3` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `INT_PROP_1` int(11) DEFAULT NULL,
  `INT_PROP_2` int(11) DEFAULT NULL,
  `LONG_PROP_1` bigint(20) DEFAULT NULL,
  `LONG_PROP_2` bigint(20) DEFAULT NULL,
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL,
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_simprop_triggers` */

/*Table structure for table `qrtz_triggers` */

DROP TABLE IF EXISTS `qrtz_triggers`;

CREATE TABLE `qrtz_triggers` (
  `SCHED_NAME` varchar(120) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) COLLATE utf8mb4_bin DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PREV_FIRE_TIME` bigint(13) DEFAULT NULL,
  `PRIORITY` int(11) DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_TYPE` varchar(8) COLLATE utf8mb4_bin NOT NULL,
  `START_TIME` bigint(13) NOT NULL,
  `END_TIME` bigint(13) DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL,
  `MISFIRE_INSTR` smallint(2) DEFAULT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `SCHED_NAME` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_triggers` */

/*Table structure for table `t_schedule_trigger` */

DROP TABLE IF EXISTS `t_schedule_trigger`;

CREATE TABLE `t_schedule_trigger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cron` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `status` char(1) COLLATE utf8mb4_bin DEFAULT NULL,
  `job_name` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `job_group` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `job_name` (`job_name`,`job_group`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `t_schedule_trigger` */

/*Table structure for table `t_schedule_trigger_param` */

DROP TABLE IF EXISTS `t_schedule_trigger_param`;

CREATE TABLE `t_schedule_trigger_param` (
  `param_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(512) COLLATE utf8mb4_bin DEFAULT NULL,
  `schedule_trigger_id` int(11) NOT NULL,
  PRIMARY KEY (`param_id`) USING BTREE,
  KEY `schedule_trigger_id` (`schedule_trigger_id`) USING BTREE,
  CONSTRAINT `t_schedule_trigger_param_ibfk_1` FOREIGN KEY (`schedule_trigger_id`) REFERENCES `t_schedule_trigger` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `t_schedule_trigger_param` */

/*Table structure for table `oauth_client_details` */

DROP TABLE IF EXISTS `oauth_client_details`;

CREATE TABLE `oauth_client_details` (
  `client_id` varchar(256) NOT NULL,
  `resource_ids` varchar(256) DEFAULT NULL,
  `client_secret` varchar(256) DEFAULT NULL,
  `scope` varchar(256) DEFAULT NULL,
  `authorized_grant_types` varchar(256) DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) DEFAULT NULL,
  `authorities` varchar(256) DEFAULT NULL,
  `access_token_validity` int DEFAULT NULL,
  `refresh_token_validity` int DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `oauth_client_details` */

insert  into `oauth_client_details`(`client_id`,`resource_ids`,`client_secret`,`scope`,`authorized_grant_types`,`web_server_redirect_uri`,`authorities`,`access_token_validity`,`refresh_token_validity`,`additional_information`,`autoapprove`) values 
('auth-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,NULL,NULL,NULL,NULL),
('codegenerator-client',NULL,'$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK','all','authorization_code,refresh_token,password',NULL,NULL,604800,604800,NULL,'1'),
('user-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,604800,604800,NULL,'1');

/*Table structure for table `sys_depart` */

DROP TABLE IF EXISTS `sys_depart`;

CREATE TABLE `sys_depart` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) DEFAULT NULL COMMENT '描述',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `org_category` varchar(10) NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) NOT NULL COMMENT '机构编码',
  `status` varchar(1) DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';

/*Data for the table `sys_depart` */

/*Table structure for table `sys_fill_rule` */

DROP TABLE IF EXISTS `sys_fill_rule`;

CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_fill_rule` */

insert  into `sys_fill_rule`(`id`,`rule_name`,`rule_code`,`rule_class`,`rule_params`,`update_by`,`update_time`,`create_by`,`create_time`) values 
('1202551334738382850','机构编码生成','org_num_role','com.starbos.cloud.oauth.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2022-05-18 12:00:20','admin','2022-05-18 12:00:12');

/*Table structure for table `sys_permission` */

DROP TABLE IF EXISTS `sys_permission`;

CREATE TABLE `sys_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT '1' COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) NOT NULL COMMENT '表单key',
  `path` varchar(258) NOT NULL COMMENT '路径',
  `component` varchar(64) DEFAULT '' COMMENT '组件',
  `title` varchar(32) NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父节点',
  `is_leaf` tinyint(1) DEFAULT '1' COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8,2) DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tag` (`perm_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_permission` */

insert  into `sys_permission`(`id`,`fsort`,`type`,`perm_tag`,`path`,`component`,`title`,`icon`,`parent_id`,`is_leaf`,`sort_no`,`fremarks`,`fstatus`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,0,0,'system','/system','Layout','系统管理','Setting',0,0,0.00,'','','2022-08-01 09:50:54','','2022-03-31 17:21:29',''),
(2,0,1,'menu','/menu','/system/menuManage','菜单管理','',1,1,2.00,'','','2022-08-01 11:27:13','','2022-03-31 18:19:39',''),
(3,0,1,'role','/role','/system/roleManage','角色管理','',1,1,3.00,'','','2022-08-01 11:27:14','','2022-04-02 17:16:42',''),
(4,0,1,'user','/user','/system/userManage','用户管理','',1,1,4.00,'','','2022-08-08 09:47:47','','2022-04-15 10:45:07',''),
(6,NULL,1,'synchronization','/synchronization','/system/enableSynchronization','启用同步','',11,1,2.00,'','1','2022-11-22 14:27:32','','2022-08-01 14:38:57',''),
(8,NULL,1,'kingdeeLog','/kingdeeLog','/manage/kingdeeLog','金蝶日志','',11,1,1.00,'','1','2022-11-22 14:27:29','','2022-08-01 14:44:30',''),
(9,NULL,1,'thirdPartyLog','/thirdPartyLog','/manage/thirdPartyLog','第三方日志','',11,1,6.00,'','1','2022-11-22 14:27:51','','2022-08-01 14:45:50',''),
(11,NULL,0,'manage','/manage','Layout','集成管理','Tickets',0,0,0.00,'','1','2022-08-08 17:15:28','','2022-08-04 08:55:24',''),
(16,NULL,1,'synchronousMonitoring','/synchronousMonitoring','/manage/synchronousMonitoring','同步监控','',11,1,5.00,'','1','2022-11-22 14:28:03','','2022-08-08 17:37:24',''),
(19,NULL,1,'formConfiguration','/formConfiguration','/manage/formConfiguration','表单配置','',11,1,7.00,'','1','2022-11-22 14:28:09','','2022-10-10 11:39:38',''),
(21,NULL,1,'manage/stso','/manage/stso','/manage/stso','同步操作','',11,1,4.00,'','1','2022-11-22 14:28:11','','2022-11-12 16:38:24',''),
(22,NULL,1,'manage/platformProducts','/manage/platformProducts','/manage/platformProducts','平台产品','',11,1,0.00,'','1','2022-11-22 14:37:09','','2022-11-14 09:09:41',''),
(23,NULL,1,'manage/productLog','/manage/productLog','/manage/productLog','产品日志','',11,1,3.00,'','1','2022-11-22 14:27:35','','2022-11-22 10:03:35','');

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) DEFAULT NULL,
  `role_Name` varchar(64) NOT NULL,
  `role_Desc` varchar(64) NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `sys_role` */

insert  into `sys_role`(`id`,`role_code`,`role_Name`,`role_Desc`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','管理员','管理员','2022-04-21 11:32:51','admin','2022-03-31 17:21:29','');

/*Table structure for table `sys_role_permission` */

DROP TABLE IF EXISTS `sys_role_permission`;

CREATE TABLE `sys_role_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_role_prem_id` (`role_id`,`perm_id`),
  KEY `idx_perm_id` (`perm_id`),
  KEY `idx_role_id` (`perm_id`),
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`),
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role_permission` */

insert  into `sys_role_permission`(`id`,`role_id`,`perm_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values
(1,1,1,'2022-08-01 09:52:02','','2022-08-01 09:52:02',''),
(2,1,2,'2022-08-01 09:52:03','','2022-08-01 09:52:03',''),
(3,1,3,'2022-08-01 09:52:05','','2022-08-01 09:52:05',''),
(4,1,4,'2022-08-01 09:52:06','','2022-08-01 09:52:06',''),
(21,1,11,'2022-08-06 16:38:22','','2022-08-06 16:38:22',''),
(23,1,16,'2022-08-08 17:37:53','','2022-08-08 17:37:53',''),
(26,1,19,'2022-10-10 11:39:48','','2022-10-10 11:39:48',''),
(29,1,22,'2022-11-14 09:09:50','','2022-11-14 09:09:50',''),
(30,1,23,'2022-11-22 10:03:51','','2022-11-22 10:03:51','');

/*Table structure for table `sys_sms` */

DROP TABLE IF EXISTS `sys_sms`;

CREATE TABLE `sys_sms` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `es_title` varchar(100) DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext COMMENT '推送内容',
  `es_send_time` datetime DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_type` (`es_type`) USING BTREE,
  KEY `index_receiver` (`es_receiver`) USING BTREE,
  KEY `index_sendtime` (`es_send_time`) USING BTREE,
  KEY `index_status` (`es_send_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms` */

/*Table structure for table `sys_sms_template` */

DROP TABLE IF EXISTS `sys_sms_template`;

CREATE TABLE `sys_sms_template` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `template_name` varchar(50) DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_templatecode` (`template_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms_template` */

insert  into `sys_sms_template`(`id`,`template_name`,`template_code`,`template_type`,`template_content`,`template_test_json`,`create_time`,`create_by`,`update_time`,`update_by`) values 
('1','系统消息通知','sys_ts_note','4','<h1>&nbsp; &nbsp; 系统通知</h1>\n<ul>\n<li>通知时间：&nbsp; ${ts_date}</li>\n<li>通知内容：&nbsp; ${ts_content}</li>\n</ul>',NULL,'2019-11-27 16:30:27','admin','2019-11-27 19:36:50','admin'),
('2','流程催办','bpm_cuiban','4','<h1>&nbsp; &nbsp;流程催办提醒</h1>\n<ul>\n<li>流程名称：&nbsp; ${bpm_name}</li>\n<li>催办任务：&nbsp; ${bpm_task}</li>\n<li>催办时间 :&nbsp; &nbsp; ${datetime}</li>\n<li>催办内容 :&nbsp; &nbsp; ${remark}</li>\n</ul>',NULL,'2019-11-27 17:08:12','admin','2019-11-27 19:36:45','admin'),
('3','流程办理超时提醒','bpm_chaoshi_tip','4','<h1>&nbsp; &nbsp;流程办理超时提醒</h1>\n<ul>\n<li>&nbsp; &nbsp;超时提醒信息：&nbsp; &nbsp; 您有待处理的超时任务，请尽快处理！</li>\n<li>&nbsp; &nbsp;超时任务标题：&nbsp; &nbsp; ${title}</li>\n<li>&nbsp; &nbsp;超时任务节点：&nbsp; &nbsp; ${task}</li>\n<li>&nbsp; &nbsp;任务处理人：&nbsp; &nbsp; &nbsp; &nbsp;${user}</li>\n<li>&nbsp; &nbsp;任务开始时间：&nbsp; &nbsp; ${time}</li>\n</ul>',NULL,'2019-11-27 19:19:24','admin','2019-11-27 19:36:37','admin'),
('4','请维护下商品单价','11111','4','<p>请帮忙维护下商品单价</p>',NULL,'2020-11-18 17:18:58','admin','2020-11-18 17:20:18','admin'),
('5','催办：${taskName}','SYS001','3','${userName}，您好！\r\n请前待办任务办理事项！${taskName}\r\n\r\n\r\n===========================\r\n此消息由系统发出','{\r\n\"taskName\":\"HR审批\",\r\n\"userName\":\"admin\"\r\n}','2018-07-05 14:46:18','admin','2018-07-05 18:31:34','admin');

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '账号',
  `realname` varchar(50) DEFAULT '' COMMENT '真名',
  `password` varchar(64) NOT NULL COMMENT '密码',
  `create_Date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_Login_Time` date DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int(11) DEFAULT '0',
  `account_Non_Expired` int(11) DEFAULT '0',
  `account_Non_Locked` int(11) DEFAULT '0',
  `credentials_Non_Expired` int(11) DEFAULT '0',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_account_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `sys_user` */

insert  into `sys_user`(`id`,`username`,`realname`,`password`,`create_Date`,`last_Login_Time`,`enabled`,`account_Non_Expired`,`account_Non_Locked`,`credentials_Non_Expired`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','张三','$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq','2021-11-13 00:00:00','2022-03-01',1,1,1,1,'2022-03-31 17:21:29','','2022-03-31 17:21:29','');

/*Table structure for table `sys_user_depart` */

DROP TABLE IF EXISTS `sys_user_depart`;

CREATE TABLE `sys_user_depart` (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_depart_groupk_userid` (`user_id`) USING BTREE,
  KEY `index_depart_groupkorgid` (`dep_id`) USING BTREE,
  KEY `index_depart_groupk_uidanddid` (`user_id`,`dep_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_user_depart` */

/*Table structure for table `sys_user_message` */

DROP TABLE IF EXISTS `sys_user_message`;

CREATE TABLE `sys_user_message` (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_auth_account` (`fauth_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Data for the table `sys_user_message` */

insert  into `sys_user_message`(`user_id`,`name`,`avatar`,`introduction`,`fauth_account`,`fenglish_name`,`fwork_no`,`fdept`,`fphone`,`fmail`,`fwork_addr`,`fposition`,`finduction_date`,`fstate`,`fdate`,`fcreator`) values 
(1,'张三','https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg','','admin','admin','114514','','','114514@homo.com','123','','2022-04-12 00:00:00','困','2022-04-02 00:00:00','');

/*Table structure for table `sys_user_role` */

DROP TABLE IF EXISTS `sys_user_role`;

CREATE TABLE `sys_user_role` (
  `user_id` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) DEFAULT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  KEY `FK_Reference_1` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`),
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_user_role` */

insert  into `sys_user_role`(`user_id`,`role_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,1,'2022-06-08 14:22:02','','2022-06-08 14:22:02','');

/*Table structure for table `undo_log` */

DROP TABLE IF EXISTS `undo_log`;

CREATE TABLE `undo_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `branch_id` bigint NOT NULL,
  `xid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `context` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `rollback_info` longblob NOT NULL,
  `log_status` int NOT NULL,
  `log_created` datetime NOT NULL,
  `log_modified` datetime NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=385 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `undo_log` */

/*Table structure for table `tb_dict_item` */

DROP TABLE IF EXISTS `tb_dict_item`;

CREATE TABLE `tb_dict_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(128) NOT NULL COMMENT '字典名称',
  `type` varchar(128) NOT NULL COMMENT '类型',
  `code` varchar(128) NOT NULL COMMENT '字典项代码（用于参数传递和存储）',
  `desc` varchar(128) DEFAULT NULL COMMENT '说明',
  `sort_order` int(11) NOT NULL COMMENT '排序（正序排列）',
  `status` int(2) DEFAULT '0' COMMENT '状态（0：正常，-1：废弃，1：只读）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_type_code` (`type`,`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='字典表';

/*Data for the table `tb_dict_item` */

insert  into `tb_dict_item`(`id`,`title`,`type`,`code`,`desc`,`sort_order`,`status`,`create_time`,`update_time`) values 
(1,'金蝶','product','kingdee',NULL,1,0,'2022-11-01 15:19:45','2022-11-01 15:19:45'),
(2,'商城','product','mall',NULL,2,0,'2022-11-01 15:20:02','2022-11-01 15:20:02');

/*Table structure for table `tb_form_table_structure` */

DROP TABLE IF EXISTS `tb_form_table_structure`;

CREATE TABLE `tb_form_table_structure` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `form_id` varchar(64) NOT NULL COMMENT '表单标识',
  `db_table_name` varchar(128) NOT NULL COMMENT '数据库表名',
  `db_table_comment` varchar(128) NOT NULL COMMENT '数据库表注释',
  `form_json` longtext NOT NULL COMMENT '前端表单Json',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='表单表结构表';

/*Data for the table `tb_form_table_structure` */

insert  into `tb_form_table_structure`(`id`,`form_id`,`db_table_name`,`db_table_comment`,`form_json`,`create_time`,`update_time`) values
(1,'kingdee','tb_kingdee_init_connect_param','金蝶配置表','{\"list\":[{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"receiveAddress\",\"rules\":[],\"label\":\"接收地址\",\"dbFieldComment\":\"接收地址\",\"type\":\"input\",\"dbFieldName\":\"receive_address\",\"key\":\"996ed7d5c2b4480b82f7a24ff7540692\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"adapterAddress\",\"rules\":[],\"label\":\"适配器地址\",\"dbFieldComment\":\"适配器地址\",\"type\":\"input\",\"dbFieldName\":\"adapter_address\",\"key\":\"e0f350fa326e4971b00725d7921e45d1\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"k3Cloudurl\",\"rules\":[],\"label\":\"金蝶地址\",\"dbFieldComment\":\"金蝶地址\",\"type\":\"input\",\"dbFieldName\":\"k3_cloud_url\",\"key\":\"e814fa940a76497986a1c44be74707d0\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"dbid\",\"rules\":[],\"label\":\"金蝶账套\",\"dbFieldComment\":\"金蝶账套\",\"type\":\"input\",\"dbFieldName\":\"dbid\",\"key\":\"74ce381b56a14fa98df0edcc247cfc5b\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"uid\",\"rules\":[],\"label\":\"用户名\",\"dbFieldComment\":\"用户名\",\"type\":\"input\",\"dbFieldName\":\"uid\",\"key\":\"8389d01a315f4965bde5016dbd822d71\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"pwd\",\"rules\":[],\"label\":\"密码\",\"dbFieldComment\":\"密码\",\"type\":\"input\",\"dbFieldName\":\"pwd\",\"key\":\"afe9c315d0e84e8398b80d44f7525f83\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"lang\",\"rules\":[],\"label\":\"端口\",\"dbFieldComment\":\"端口\",\"type\":\"input\",\"dbFieldName\":\"lang\",\"key\":\"9b4cac0704274b2691b8d4c9a7b86a15\"}],\"config\":{\"dbTableName\":\"tb_kingdee_init_connect_param\",\"formId\":\"kingdee\",\"dbTableComment\":\"金蝶配置表\",\"size\":\"default\",\"labelPosition\":\"right\",\"labelWidth\":100,\"hideRequiredAsterisk\":false}}','2022-11-30 14:29:48','2022-11-30 14:55:25'),
(2,'mall','tb_mall_init_connect_param','商城配置表','{\"list\":[{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"receiveaddress\",\"rules\":[],\"label\":\"接收地址\",\"dbFieldComment\":\"接收地址\",\"type\":\"input\",\"dbFieldName\":\"receive_address\",\"key\":\"996ed7d5c2b4480b82f7a24ff7540692\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"adapterAddress\",\"rules\":[],\"label\":\"适配器地址\",\"dbFieldComment\":\"适配器地址\",\"type\":\"input\",\"dbFieldName\":\"adapter_address\",\"key\":\"8155a570f51d497f854452c6a01bfe62\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"malladdress\",\"rules\":[],\"label\":\"商城地址\",\"dbFieldComment\":\"商城地址\",\"type\":\"input\",\"dbFieldName\":\"mall_address\",\"key\":\"c0cdea1f56d94db786dbc6a98a62be3f\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"account\",\"rules\":[],\"label\":\"用户名\",\"dbFieldComment\":\"用户名\",\"type\":\"input\",\"dbFieldName\":\"account\",\"key\":\"e1273dc93166498886af3f70384f3418\"},{\"options\":{\"clearable\":false,\"readonly\":false,\"maxlength\":null,\"defaultValue\":\"\",\"prefix\":\"\",\"width\":\"100%\",\"prepend\":\"\",\"disabled\":false,\"rules\":{\"pattern\":\"\",\"trigger\":\"blur\",\"message\":\"\",\"type\":\"any\",\"enum\":\"\",\"required\":false},\"placeholder\":\"\",\"suffix\":\"\",\"append\":\"\"},\"model\":\"password\",\"rules\":[],\"label\":\"密码\",\"dbFieldComment\":\"密码\",\"type\":\"input\",\"dbFieldName\":\"password\",\"key\":\"33f1b7786cc84035b4b9353a13e38ee5\"}],\"config\":{\"dbTableName\":\"tb_mall_init_connect_param\",\"formId\":\"mall\",\"dbTableComment\":\"商城配置表\",\"size\":\"default\",\"labelPosition\":\"right\",\"labelWidth\":100,\"hideRequiredAsterisk\":false}}','2022-11-30 14:32:35','2022-11-30 14:47:56');

/*Table structure for table `tb_init_connect_param` */

DROP TABLE IF EXISTS `tb_init_connect_param`;

CREATE TABLE `tb_init_connect_param` (
   `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
   `k3_cloud_url` varchar(64) NOT NULL COMMENT '金蝶地址',
   `dbid` varchar(64) NOT NULL COMMENT '金蝶账套',
   `uid` varchar(64) NOT NULL COMMENT '用户名',
   `pwd` varchar(64) NOT NULL COMMENT '密码',
   `lang` int NOT NULL COMMENT '端口',
   `is_auto_submit` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否提交审核',
   `third_party_url` varchar(128) NOT NULL COMMENT '第三方路径',
   `duration` int DEFAULT '1' COMMENT '定时任务时长/分钟',
   `lic_cipher_text` varchar(255) DEFAULT NULL COMMENT 'Lic密文',
   `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
   `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='金蝶配置表';

/*Data for the table `tb_init_connect_param` */

DROP TABLE IF EXISTS `tb_kingdee_init_connect_param`;

CREATE TABLE `tb_kingdee_init_connect_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `receive_address` varchar(128) NOT NULL COMMENT '接收地址',
  `adapter_address` varchar(128) NOT NULL COMMENT '适配器地址',
  `k3_cloud_url` varchar(128) NOT NULL COMMENT '金蝶地址',
  `dbid` varchar(128) NOT NULL COMMENT '金蝶账套',
  `uid` varchar(128) NOT NULL COMMENT '用户名',
  `pwd` varchar(128) NOT NULL COMMENT '密码',
  `lang` varchar(128) NOT NULL COMMENT '端口',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶配置表';

/*Data for the table `tb_init_connect_param` */


/*Table structure for table `tb_kingdee_common_config` */

DROP TABLE IF EXISTS `tb_kingdee_common_config`;

CREATE TABLE `tb_kingdee_common_config` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `platform_product_relation_id` int NOT NULL COMMENT '平台产品关系id',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `doc_type` varchar(64) NOT NULL COMMENT '第三方标识',
  `name` varchar(64) NOT NULL COMMENT '日志名称',
  `direction` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '产品方向',
  `operation` tinyint(1) NOT NULL COMMENT '操作(1-查询 2-创建/更新 3-同步)',
  `encapsulation_format` tinyint(1) DEFAULT '2' COMMENT '封装格式(1-全部 2-聚合)',
  `primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据主键字段',
  `entry_primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据分录主键',
  `mes_entry_name` varchar(64) DEFAULT NULL COMMENT 'MES分录标识',
  `entry_name` varchar(64) DEFAULT NULL COMMENT '分录标识',
  `fathers_form_id` varchar(64) DEFAULT NULL COMMENT '源单标识',
  `father_entry_name` varchar(64) DEFAULT NULL COMMENT '源单分录标识',
  `push_rule` varchar(64) DEFAULT NULL COMMENT '下推规则',
  `is_in_transaction` tinyint(1) DEFAULT '1' COMMENT '是否在事务中',
  `is_auto_perform` tinyint(1) DEFAULT '3' COMMENT '执行步骤（0-暂存，1-保存，2-提交，3-审核）',
  `plug_in_url` text COMMENT '插件地址',
  `custom_sql` text COMMENT '自定义Sql',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `pai_xu` int  NULL DEFAULT COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='金蝶通用配置表';

/*Data for the table `tb_kingdee_common_config` */

insert  into `tb_kingdee_common_config`(`id`,`platform_product_relation_id`,`s_form_id`,`doc_type`,`name`,`direction`,`operation`,`primary_key_field`,`entry_primary_key_field`,`mes_entry_name`,`entry_name`,`fathers_form_id`,`father_entry_name`,`push_rule`,`is_in_transaction`,`is_auto_perform`,`plug_in_url`,`custom_sql`,`create_time`,`update_time`) values 
(1,1,'BD_Customer','CUSTOMER','客户','金蝶-商城',3,'FCUSTID','','bs_cust_dt','','','ERP_SIC','',1,3,'','/*dialect*/\nSELECT\n	t1.FNUMBER FNumber, t2.FNAME FName, t3.FDATAVALUE FCOUNTRY, FADDRESS, t4.FEMAIL FContactEmail, t5.FNAME FCONTACT, t4.FBIZADDRESS FBizAddress,t6.FNUMBER FSELLER,FREGISTERADDRESS FRegisterAddress\nFROM T_BD_CUSTOMER t1\n	LEFT JOIN (SELECT * FROM T_BD_CUSTOMER_L WHERE FLOCALEID=2052) t2 ON t1.FCUSTID=t2.FCUSTID\n	LEFT JOIN (SELECT * FROM T_BAS_ASSISTANTDATAENTRY_L WHERE FLOCALEID=2052) t3 ON t1.FCOUNTRY=FENTRYID\n	LEFT JOIN (SELECT * FROM T_BD_COMMONCONTACT WHERE FCOMPANYTYPE=\'BD_Customer\') t4 ON t4.FCOMPANY=t1.FCUSTID\n	LEFT JOIN (SELECT * FROM T_BD_COMMONCONTACT_L WHERE FLOCALEID=2052) t5 ON t4.FCONTACTID=t5.FCONTACTID\n	LEFT JOIN V_BD_SALESMAN t6 ON t6.fid=t1.FSELLER\nWHERE t1.FCUSTID = @FCUSTID','2022-11-02 11:34:42','2022-12-02 15:38:12'),
(2,1,'BD_OPERATOR','SALER','销售员','金蝶-商城',3,'FID','','','','','ERP_SIC','',1,3,'','','2022-11-16 10:23:08','2022-12-01 16:26:50'),
(3,1,'SAL_OUTSTOCK','ISSUE','销售出库单','金蝶-商城',3,'FID','','','','','ERP_SIC','',1,3,'','','2022-11-02 14:48:17','2022-11-18 16:34:55'),
(4,1,'SAL_DELIVERYNOTICE','NOTICE','发货通知单','金蝶-商城',3,'FID','','','','','ERP_SIC','',1,3,'','','2022-11-02 14:59:47','2022-11-18 16:34:56'),
(5,1,'LQKJ_WorkOrder','ORDER','随工单','商城-金蝶',2,'','','','FEntity','','','',1,3,'','','2022-11-02 15:01:25','2022-11-18 16:35:01'),
(9,1,'SAL_SaleOrder','SALE','销售订单','金蝶-商城',3,'FID','','','','','ERP_SIC','',1,3,'','','2022-12-07 09:57:10','2022-12-07 10:58:19'),
(10,1,'SAL_SaleOrderChange','SALE_CHANGE','销售订单变更单','金蝶-商城',1,'FID','','','','','ERP_SIC','',1,3,'','','2022-12-07 11:41:43','2022-12-07 11:44:40');

/*Table structure for table `tb_kingdee_field_mapping` */

DROP TABLE IF EXISTS `tb_kingdee_field_mapping`;

CREATE TABLE `tb_kingdee_field_mapping` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `kingdee_common_config_id` int NOT NULL COMMENT '金蝶通用配置id',
  `kingdee_field` varchar(128) NOT NULL COMMENT '金蝶字段',
  `kingdee_field_name` varchar(128) NOT NULL COMMENT '金蝶字段名称',
  `field_type` varchar(128) NOT NULL COMMENT '字段类型',
  `retrieval_field` varchar(64) DEFAULT NULL COMMENT '检索字段',
  `is_entry_field` varchar(64) NOT NULL COMMENT '是否是分录字段',
  `third_party_field` varchar(128) NOT NULL COMMENT '第三方字段',
  `third_party_field_name` varchar(128) NOT NULL COMMENT '第三方字段名称',
  `sort_order` int NOT NULL COMMENT '排序顺序',
  `default_value` varchar(128) COMMENT '默认值',
  `map_bill` varchar(128) COMMENT '匹配表单',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='金蝶字段映射表';

/*Data for the table `tb_kingdee_field_mapping` */

insert  into `tb_kingdee_field_mapping`(`id`,`kingdee_common_config_id`,`kingdee_field`,`kingdee_field_name`,`field_type`,`retrieval_field`,`is_entry_field`,`third_party_field`,`third_party_field_name`,`sort_order`,`create_time`,`update_time`) values 
(1,1,'FNumber','客户编码','文本','','false','customer_code','客户编码',1,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(2,1,'FName','客户名称','文本','','false','customer_name','客户名称',2,'2022-11-08 14:31:42','2022-11-16 15:15:41'),
(3,1,'FCOUNTRY','国家','基础资料','FNumber','true','country','国家',3,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(4,1,'FADDRESS','通讯地址','文本','','true','postal_address','通讯地址',4,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(10,3,'F_LQKJ_ShoppingMall','内部订单号','数值','','false','order_id','内部订单号',1,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(11,3,'FDocumentStatus','单据状态','文本','','false','order_status','单据状态',2,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(12,4,'F_LQKJ_ShoppingMall','内部订单号','数值','','false','order_id','内部订单号',1,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(13,4,'FDocumentStatus','单据状态','文本','','false','order_status','单据状态',2,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(14,5,'F_LQKJ_Customer','客户','基础资料','FNumber','false','CUSTOMER','客户',1,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(15,5,'F_LQKJ_ContactPhoneOne','联系人电话','文本','','false','CONTACT_PHONE','联系人电话',2,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(16,5,'F_LQKJ_InternalOrderNo','内部订单号','文本','','false','ORDER_NO','内部订单号',3,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(17,5,'F_LQKJ_InternalEQName','内部设备名称','基础资料','FNumber','true','EQUIPMENT_NAME','内部设备名称',4,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(18,5,'F_LQKJ_ShoppingMall','商城订单','数值','','false','ORDER_ID','商城订单',5,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(19,5,'F_LQKJ_EquipmentModel','设备型号','文本','','true','EQUIPMENT_MODEL','设备型号',6,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(20,5,'F_LQKJ_BomID','BOM编码','基础资料','FNumber','true','BOM_CODE','BOM编码',7,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(21,5,'F_LQKJ_QTY','订单数量','数值','','true','ORDER_QUANTITY','订单数量',8,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(22,5,'F_LQKJ_DeliveryDate','交货日期','文本','','true','DELIVERY_DATE','交货日期',9,'2022-11-08 14:31:42','2022-11-08 14:31:42'),
(26,1,'FContactEmail','联系人邮箱','文本','','true','contacts_email','邮箱',5,'2022-11-16 09:22:25','2022-11-16 11:26:10'),
(29,2,'FNumber','业务员编码','文本','','false','operator_code','业务员编码',1,'2022-11-16 10:24:01','2022-11-16 15:11:13'),
(30,2,'FName','名称','文本','','false','operator_name','名称',2,'2022-11-16 10:24:25','2022-11-16 11:31:03'),
(31,1,'FCONTACT','联系人名称','文本','','true','contacts_name','联系人名称',6,'2022-11-16 10:27:00','2022-11-16 11:29:23'),
(32,1,'FBizAddress','详细地址','文本','','true','detailed_address','详细地址',7,'2022-11-16 10:28:30','2022-11-16 11:29:57'),
(33,1,'FSELLER','销售员','基础资料','FNumber','false','salesperson','销售员',8,'2022-11-24 11:59:49','2022-11-24 17:28:22'),
(37,5,'F_LQKJ_OfferAmount','单价','精准数值','','true','OFFER_AMOUNT','单价',10,'2022-11-30 17:56:09','2022-11-30 17:56:09'),
(38,5,'F_LQKJ_TaxRate','税率','精准数值','','true','TAX_RATE','税率',11,'2022-12-01 09:48:17','2022-12-01 09:48:17');

/*Table structure for table `tb_kingdee_log` */

DROP TABLE IF EXISTS `tb_kingdee_log`;

CREATE TABLE `tb_kingdee_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) NOT NULL COMMENT '业务名称',
  `queue_id` varchar(128) NOT NULL COMMENT '唯一标识',
  `request` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '1' COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext COMMENT '响应信息',
  `message` longtext COMMENT '错误原因',
  `cost_time` int(11) DEFAULT '0' COMMENT '耗时（毫秒）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_queue_id` (`queue_id`),
  KEY `index_create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶日志记录表';

/*Data for the table `tb_kingdee_log` */

/*Table structure for table `tb_mall_common_config` */

DROP TABLE IF EXISTS `tb_mall_common_config`;

CREATE TABLE `tb_mall_common_config` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `platform_product_relation_id` int NOT NULL COMMENT '平台产品关系id',
  `doc_type` varchar(64) NOT NULL COMMENT '第三方唯一标识',
  `s_form_id` varchar(64) NOT NULL COMMENT '商城标识',
  `name` varchar(64) NOT NULL COMMENT '日志名称',
  `direction` varchar(128) NOT NULL COMMENT '方向',
  `operation` tinyint(1) NOT NULL COMMENT '操作(1-查询 2-创建/更新 3-同步)',
  `encapsulation_format` tinyint(1) NOT NULL COMMENT '封装格式(1-全部 2-聚合)',
  `entry_name` varchar(64) DEFAULT NULL COMMENT '分录标识',
  `custom_sql` text COMMENT '自定义Sql',
  `plug_in_url` text COMMENT '插件地址',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='商城表单配置表';

/*Data for the table `tb_mall_common_config` */

insert  into `tb_mall_common_config`(`id`,`platform_product_relation_id`,`doc_type`,`s_form_id`,`name`,`direction`,`operation`,`encapsulation_format`,`entry_name`,`custom_sql`,`create_time`,`update_time`) values 
(1,2,'ORDER','work_order','商城订单','商城-金蝶',3,1,NULL,NULL,'2022-11-23 15:38:00','2022-11-23 15:38:00');

/*Table structure for table `tb_mall_field_mapping` */

DROP TABLE IF EXISTS `tb_mall_field_mapping`;

CREATE TABLE `tb_mall_field_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `mall_common_config_id` int(11) NOT NULL COMMENT '商城表单配置id',
  `field_before_mapping` varchar(128) NOT NULL COMMENT '映射前字段',
  `field_before_mapping_name` varchar(128) NOT NULL COMMENT '映射前字段名称',
  `field_type` varchar(128) NOT NULL COMMENT '字段类型',
  `is_entry_field` varchar(64) NOT NULL COMMENT '是否是分录字段',
  `field_after_mapping` varchar(128) NOT NULL COMMENT '映射后字段',
  `field_after_mapping_name` varchar(128) NOT NULL COMMENT '映射后字段名称',
  `sort_order` int(11) NOT NULL COMMENT '排序顺序',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商城字段映射表';

/*Data for the table `tb_mall_field_mapping` */

insert  into `tb_mall_field_mapping`(`id`,`mall_common_config_id`,`field_before_mapping`,`field_before_mapping_name`,`field_type`,`is_entry_field`,`field_after_mapping`,`field_after_mapping_name`,`sort_order`,`create_time`,`update_time`) values 
(1,1,'customer','客户','文本','false','CUSTOMER','客户',1,'2022-11-23 16:42:36','2022-11-23 16:42:52'),
(2,1,'contact_phone','联系人电话','文本','false','CONTACT_PHONE','联系人电话',2,'2022-11-23 16:43:54','2022-11-24 09:29:28'),
(3,1,'order_id','商城订单','数值','false','ORDER_ID','商城订单',3,'2022-11-23 16:44:25','2022-11-24 09:29:25'),
(4,1,'equipment_name','内部设备名称','文本','false','EQUIPMENT_NAME','内部设备名称',4,'2022-11-24 09:29:20','2022-11-24 09:29:20'),
(5,1,'equipment_model','设备型号','文本','false','EQUIPMENT_MODEL','设备型号',5,'2022-11-24 09:30:24','2022-11-24 09:30:24'),
(6,1,'bom_code','BOM编码','文本','false','BOM_CODE','BOM编码',6,'2022-11-24 09:31:15','2022-11-24 09:31:15'),
(7,1,'order_quantity','订单数量','数值','false','ORDER_QUANTITY','订单数量',7,'2022-11-24 09:31:59','2022-11-24 09:31:59'),
(8,1,'delivery_date','交货日期','文本','false','DELIVERY_DATE','交货日期',8,'2022-11-24 09:32:42','2022-11-24 09:32:42'),
(9,1,'price','单价','精准数值','false','OFFER_AMOUNT','单价',9,'2022-11-30 17:45:04','2022-11-30 17:56:15'),
(10,1,'tax_rate','税率','精准数值','false','TAX_RATE','税率',10,'2022-12-01 14:36:43','2022-12-01 14:36:43');

/*Table structure for table `tb_mall_init_connect_param` */

DROP TABLE IF EXISTS `tb_mall_init_connect_param`;

CREATE TABLE `tb_mall_init_connect_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `receive_address` varchar(128) NOT NULL COMMENT '接收地址',
  `adapter_address` varchar(128) NOT NULL COMMENT '适配器地址',
  `mall_address` varchar(128) NOT NULL COMMENT '商城地址',
  `account` varchar(128) NOT NULL COMMENT '用户名',
  `password` varchar(128) NOT NULL COMMENT '密码',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商城配置表';

/*Data for the table `tb_mall_init_connect_param` */

/*Table structure for table `tb_mall_synchronization_record` */

DROP TABLE IF EXISTS `tb_mall_synchronization_record`;

CREATE TABLE `tb_mall_synchronization_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) NOT NULL COMMENT '同步记录主键',
  `data_id` int(11) NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int(11) DEFAULT NULL COMMENT '同步记录数据分录内码',
  `form` varchar(64) NOT NULL COMMENT '同步记录表单标识',
  `operation` varchar(64) NOT NULL COMMENT '操作',
  `queue_id` varchar(128) DEFAULT NULL COMMENT '唯一标识',
  `message` longtext COMMENT '错误原因',
  `status` tinyint(1) DEFAULT '0' COMMENT '同步状态（0-未同步，1-同步中，2-同步失败，3-同步成功）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_fid` (`fid`),
  KEY `index_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商城同步记录表';

/*Data for the table `tb_mall_synchronization_record` */

/*Table structure for table `tb_mall_synchronization_record_temp` */

DROP TABLE IF EXISTS `tb_mall_synchronization_record_temp`;

CREATE TABLE `tb_mall_synchronization_record_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) NOT NULL COMMENT '同步记录主键',
  `data_id` int(11) NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int(11) DEFAULT NULL COMMENT '同步记录数据分录内码',
  `form` varchar(64) NOT NULL COMMENT '同步记录表单标识',
  `operation` varchar(64) NOT NULL COMMENT '操作',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_fid` (`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商城同步记录临时表';

/*Data for the table `tb_mall_synchronization_record_temp` */

/*Table structure for table `tb_platform_product_relation` */

DROP TABLE IF EXISTS `tb_platform_product_relation`;

CREATE TABLE `tb_platform_product_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `product_before_code` varchar(64) NOT NULL COMMENT '产品前编码',
  `product_after_code` varchar(64) NOT NULL COMMENT '产品后编码',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='平台产品关系表';

/*Data for the table `tb_platform_product_relation` */

insert  into `tb_platform_product_relation`(`id`,`product_before_code`,`product_after_code`,`create_time`,`update_time`) values
(1,'kingdee','mall','2022-11-22 09:11:39','2022-11-28 11:13:39'),
(2,'mall','kingdee','2022-11-29 10:49:05','2022-12-07 16:04:20');

/*Table structure for table `tb_quartz_job` */

DROP TABLE IF EXISTS `tb_quartz_job`;

CREATE TABLE `tb_quartz_job` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `job_class_name` varchar(255) DEFAULT NULL COMMENT '任务类名',
  `cron_expression` varchar(255) DEFAULT NULL COMMENT 'cron表达式',
  `parameter` varchar(255) DEFAULT NULL COMMENT '参数',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态（0-关闭 1-启动）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='定时任务表';

/*Data for the table `tb_quartz_job` */

insert  into `tb_quartz_job`(`id`,`job_class_name`,`cron_expression`,`parameter`,`description`,`status`,`create_time`,`update_time`) values 
(1,'com.system.quartz.job.KingDeeSynchronizationJob','0 */1  * * * ?','','金蝶同步定时任务',0,'2022-07-19 11:05:44','2022-11-09 16:36:55'),
(2,'com.system.quartz.job.MallSynchronizationJob','0 */1  * * * ?','','商城同步定时任务',0,'2022-11-24 11:02:25','2022-11-24 11:02:25');

/*Table structure for table `tb_synchronization_operation` */

DROP TABLE IF EXISTS `tb_synchronization_operation`;

CREATE TABLE `tb_synchronization_operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `platform_product_relation_id` int(11) NOT NULL COMMENT '平台产品关系id',
  `job_class_name` varchar(255) NOT NULL COMMENT '任务类名',
  `common_config_id` varchar(64) NOT NULL COMMENT '通用配置id',
  `receive_address` text COMMENT '接收地址',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='同步操作表';

/*Data for the table `tb_synchronization_operation` */

/*Table structure for table `tb_synchronization_record` */

DROP TABLE IF EXISTS `tb_synchronization_record`;

CREATE TABLE `tb_synchronization_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) NOT NULL COMMENT '同步记录主键',
  `data_id` int(11) NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int(11) DEFAULT NULL COMMENT '同步记录数据分录内码',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `queue_id` varchar(128) DEFAULT NULL COMMENT '唯一标识',
  `message` longtext COMMENT '错误原因',
  `status` tinyint(1) DEFAULT '0' COMMENT '同步状态（0-未同步，1-同步中，2-同步失败，3-同步成功）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_fid` (`fid`),
  KEY `index_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶同步记录表';

/*Data for the table `tb_synchronization_record` */

/*Table structure for table `tb_synchronization_record_temp` */

DROP TABLE IF EXISTS `tb_synchronization_record_temp`;

CREATE TABLE `tb_synchronization_record_temp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `fid` varchar(128) NOT NULL COMMENT '同步记录主键',
  `data_id` int(11) NOT NULL COMMENT '同步记录数据内码',
  `entry_id` int(11) DEFAULT NULL COMMENT '同步记录数据分录内码',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_fid` (`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='金蝶同步记录临时表';

/*Data for the table `tb_synchronization_record_temp` */

/*Table structure for table `tb_third_party_log` */

DROP TABLE IF EXISTS `tb_third_party_log`;

CREATE TABLE `tb_third_party_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) NOT NULL COMMENT '业务名称',
  `code` varchar(128) NOT NULL COMMENT '业务标识',
  `queue_id` varchar(255) NOT NULL COMMENT '唯一标识',
  `request` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '1' COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext COMMENT '响应信息',
  `message` longtext COMMENT '错误原因',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_queue_id` (`queue_id`),
  KEY `index_create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='第三方日志记录表';

/*Data for the table `tb_third_party_log` */

/*Table structure for table `tb_lic` */

DROP TABLE IF EXISTS `tb_lic`;

CREATE TABLE `tb_lic` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `lic_cipher_text` varchar(255) DEFAULT NULL COMMENT 'Lic密文',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Lic记录表';

/*Data for the table `tb_lic` */

/*Table structure for table `tb_product_log` */

DROP TABLE IF EXISTS `tb_product_log`;

CREATE TABLE `tb_product_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `platform_product_relation_id` int(11) NOT NULL COMMENT '平台产品关系id',
  `queue_id` varchar(128) NOT NULL COMMENT '唯一标识',
  `name` varchar(128) NOT NULL COMMENT '业务名称',
  `code` varchar(128) NOT NULL COMMENT '业务标识',
  `direction` varchar(128) NOT NULL COMMENT '方向',
  `request` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '1' COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext COMMENT '响应信息',
  `message` longtext COMMENT '错误原因',
  `cost_time` int(11) DEFAULT '0' COMMENT '耗时（毫秒）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_queue_id` (`queue_id`),
  KEY `index_name` (`name`),
  KEY `index_code` (`code`),
  KEY `index_create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='产品日志';

/*Data for the table `tb_product_log` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
