package com.system.api;

import com.system.enums.ProductAdapterEnum;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
public class CommonHttpApi {

    public static void commonConfigRefresh(Map<String, Object> data, Integer id, String sFormId, String docType, Integer operation) {
        try {
            Map<String, Object> map = new HashMap<>(3);
            map.put("id", id);
            map.put("sFormId", sFormId);
            map.put("docType", docType);
            map.put("operation", operation);
            HttpUtil.httpPost(data.get("adapterAddress") + "api/common/config/refresh", JsonUtil.toString(map));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String initConnectParamRefresh(Map<String, Object> data) {
        try {
            return HttpUtil.httpPost(data.get("adapterAddress") + "/api/init/connect/param/refresh", JsonUtil.toString(data)).getBody();
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String initConnectParamCheck(Map<String, Object> data) {
        try {
            return HttpUtil.httpPost(data.get("adapterAddress") + "/api/init/connect/param/check", JsonUtil.toString(data)).getBody();
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void synchronizationOperationRefresh(String key, Integer id) {
        try {
            Map<String, Object> map = new HashMap<>(1);
            map.put("id", id);
            HttpUtil.httpPost(ProductAdapterEnum.getValue(key) + "/api/synchronization/operation/refresh", JsonUtil.toString(map));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void formTableStructureConfigRefresh(Map<String, Object> data, Integer id, String formId) {
        try {
            Map<String, Object> map = new HashMap<>(1);
            map.put("id", id);
            map.put("formId", formId);
            HttpUtil.httpPost(data.get("adapterAddress") + "api/form/table/structure/config/refresh", JsonUtil.toString(map));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
