package com.system.controller;

import com.system.serivce.IDatabaseTableService;
import com.system.transfer.table.TableStructureDetailInVo;
import com.system.transfer.response.RestResponse;
import com.system.transfer.table.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "表单配置")
@RestController
@RequestMapping("/api")
public class DatabaseTableController {

    @Autowired
    private IDatabaseTableService databaseTableService;


    @ApiOperation("表单列表")
    @GetMapping("/form/table/structure/list")
    public RestResponse formTableStructureList(@ModelAttribute TableStructureListInVo inVo) {
        TableStructureListOutVo outVo = databaseTableService.formTableStructureList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("表单详情")
    @GetMapping("/form/table/structure/detail")
    public RestResponse formTableStructureDetail(@ModelAttribute TableStructureDetailInVo inVo) {
        TableStructureDetailOutVo outVo = databaseTableService.formTableStructureDetail(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("表单创建")
    @PostMapping("/form/table/structure/create")
    public RestResponse formTableStructureCreate(@RequestBody TableStructureCreateInVo inVo) {
        return databaseTableService.formTableStructureCreate(inVo);
    }

    @ApiOperation("表单删除")
    @DeleteMapping("/form/table/structure/delete")
    public RestResponse formTableStructureDelete(@ModelAttribute TableStructureDeleteInVo inVo) {
        return databaseTableService.formTableStructureDelete(inVo);
    }

    @ApiOperation("表单结构及数据")
    @GetMapping("/form/table/structure/data")
    public RestResponse formTableStructureData(@ModelAttribute TableStructureDataInVo inVo) {
        TableStructureDataOutVo outVo = databaseTableService.formTableStructureData(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("表单数据删除")
    @DeleteMapping("/form/table/structure/data/delete")
    public RestResponse formTableStructureDataDelete(@ModelAttribute TableStructureDataDeleteInVo inVo) {
        return databaseTableService.formTableStructureDataDelete(inVo);
    }

    @ApiOperation("通用表单数据表创建")
    @PostMapping("/form/table/structure/common/config/create")
    public RestResponse formTableStructureCommonConfigCreate(@RequestBody TableStructureCommonConfigCreateInVo inVo) {
        return databaseTableService.formTableStructureCommonConfigCreate(inVo);
    }


}
