package com.system.controller;

import com.system.serivce.IDictItemService;
import com.system.transfer.configure.DictItemListInVo;
import com.system.transfer.configure.DictItemListOutVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "字典项")
@RestController
@RequestMapping("/api")
public class DictItemController {

    @Autowired
    private IDictItemService dictItemService;


    @ApiOperation("字典项列表")
    @GetMapping("/dict/item/list")
    public RestResponse dictItemList(@ModelAttribute DictItemListInVo inVo) {
        DictItemListOutVo outVo = dictItemService.dictItemList(inVo);
        return RestResponse.success(outVo);
    }


}
