package com.system.controller;

import com.system.serivce.IKingDeeFieldMappingService;
import com.system.transfer.kingdee.*;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "金蝶字段映射")
@RestController
@RequestMapping("/api")
public class KingDeeFieldMappingController {

    @Autowired
    private IKingDeeFieldMappingService kingDeeFieldMappingService;


    @ApiOperation("金蝶字段映射列表")
    @GetMapping("/kingdee/field/mapping/list")
    public RestResponse kingdeeFieldMappingList(@ModelAttribute KingDeeFieldMappingListInVo inVo) {
        KingDeeFieldMappingListOutVo outVo = kingDeeFieldMappingService.kingdeeFieldMappingList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("金蝶字段映射创建")
    @PostMapping("/kingdee/field/mapping/create")
    public RestResponse kingdeeFieldMappingCreate(@RequestBody KingDeeFieldMappingCreateInVo inVo) {
        return kingDeeFieldMappingService.kingdeeFieldMappingCreate(inVo);
    }

    @ApiOperation("金蝶字段映射更新")
    @PutMapping("/kingdee/field/mapping/update")
    public RestResponse kingdeeFieldMappingUpdate(@RequestBody KingDeeFieldMappingUpdateInVo inVo) {
        return kingDeeFieldMappingService.kingdeeFieldMappingUpdate(inVo);
    }

    @ApiOperation("金蝶字段映射删除")
    @DeleteMapping("/kingdee/field/mapping/delete")
    public RestResponse kingdeeFieldMappingDelete(@ModelAttribute KingDeeFieldMappingDeleteInVo inVo) {
        return kingDeeFieldMappingService.kingdeeFieldMappingDelete(inVo);
    }


}
