package com.system.controller;

import com.system.serivce.ILicFileService;
import com.system.transfer.configure.LicInfoFileImportInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "Lic验证")
@RestController
@RequestMapping("/api")
public class LicFileController {

    @Autowired
    private ILicFileService licFileService;


    @ApiOperation("Lic文件导入")
    @PostMapping("/lic/info/file/import")
    public RestResponse licInfoFileImport(@ModelAttribute LicInfoFileImportInVo inVo) {
        return licFileService.licInfoFileImport(inVo);
    }

    @ApiOperation("获取MAC地址")
    @GetMapping("/mac/address/detail")
    public RestResponse macAddressDetail() {
        return licFileService.macAddressDetail();
    }

    @ApiOperation("流下载文件（测试）")
    @PostMapping("/lic/info/file/download")
    public RestResponse licInfoFileDownload() {
        return licFileService.licInfoFileDownload();
    }


}
