package com.system.controller;

import com.system.serivce.IMallCommonConfigService;
import com.system.transfer.mall.*;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "商城通用配置")
@RestController
@RequestMapping("/api")
public class MallCommonConfigController {

    @Autowired
    private IMallCommonConfigService mallCommonConfigService;


    @ApiOperation("商城通用配置列表")
    @GetMapping("/mall/common/config/list")
    public RestResponse mallCommonConfigList(@ModelAttribute MallCommonConfigListInVo inVo) {
        MallCommonConfigListOutVo outVo = mallCommonConfigService.mallCommonConfigList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("商城通用配置创建")
    @PostMapping("/mall/common/config/create")
    public RestResponse mallCommonConfigCreate(@RequestBody MallCommonConfigCreateInVo inVo) {
        return mallCommonConfigService.mallCommonConfigCreate(inVo);
    }

    @ApiOperation("商城通用配置更新")
    @PutMapping("/mall/common/config/update")
    public RestResponse mallCommonConfigUpdate(@RequestBody MallCommonConfigUpdateInVo inVo) {
        return mallCommonConfigService.mallCommonConfigUpdate(inVo);
    }

    @ApiOperation("商城通用配置删除")
    @DeleteMapping("/mall/common/config/delete")
    public RestResponse mallCommonConfigDelete(@RequestBody MallCommonConfigDeleteInVo inVo) {
        return mallCommonConfigService.mallCommonConfigDelete(inVo);
    }


}
