package com.system.controller;

import com.system.serivce.IMallCommonSyncService;
import com.system.transfer.mall.MallTriggerSynchronizationInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "商城同步")
@RestController
@RequestMapping("/api")
public class MallCommonSyncController {

    @Autowired
    private IMallCommonSyncService mallCommonSyncService;


    @ApiOperation("触发同步")
    @PostMapping("/mall/trigger/synchronization")
    public RestResponse mallTriggerSynchronization(@RequestBody MallTriggerSynchronizationInVo inVo) {
        mallCommonSyncService.mallTriggerSynchronization(inVo);
        return RestResponse.success();
    }


}
