package com.system.controller;

import com.system.serivce.IMallFieldMappingService;
import com.system.transfer.mall.*;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "商城字段映射")
@RestController
@RequestMapping("/api")
public class MallFieldMappingController {

    @Autowired
    private IMallFieldMappingService mallFieldMappingService;


    @ApiOperation("商城字段映射列表")
    @GetMapping("/mall/field/mapping/list")
    public RestResponse mallFieldMappingList(@ModelAttribute MallFieldMappingListInVo inVo) {
        MallFieldMappingListOutVo outVo = mallFieldMappingService.mallFieldMappingList(inVo);
        return RestResponse.success(outVo);
    }
    
    @ApiOperation("商城字段映射创建")
    @PostMapping("/mall/field/mapping/create")
    public RestResponse mallFieldMappingCreate(@RequestBody MallFieldMappingCreateInVo inVo) {
        mallFieldMappingService.mallFieldMappingCreate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("商城字段映射更新")
    @PutMapping("/mall/field/mapping/update")
    public RestResponse mallFieldMappingUpdate(@RequestBody MallFieldMappingUpdateInVo inVo) {
        mallFieldMappingService.mallFieldMappingUpdate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("商城字段映射删除")
    @DeleteMapping("/mall/field/mapping/delete")
    public RestResponse mallFieldMappingDelete(@RequestBody MallFieldMappingDeleteInVo inVo) {
        mallFieldMappingService.mallFieldMappingDelete(inVo);
        return RestResponse.success();
    }


}
