package com.system.controller;

import com.system.serivce.IPlatformProductRelationService;
import com.system.transfer.product.PlatformProductRelationCreateInVo;
import com.system.transfer.product.PlatformProductRelationDeleteInVo;
import com.system.transfer.product.PlatformProductRelationListInVo;
import com.system.transfer.product.PlatformProductRelationListOutVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "平台产品")
@RestController
@RequestMapping("/api")
public class PlatformProductRelationController {

    @Autowired
    private IPlatformProductRelationService platformProductRelationService;

    @ApiOperation("平台产品关系列表")
    @GetMapping("/platform/product/relation/list")
    public RestResponse platformProductRelationList(@ModelAttribute PlatformProductRelationListInVo inVo) {
        PlatformProductRelationListOutVo outVo = platformProductRelationService.platformProductRelationList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("平台产品关系创建")
    @PostMapping("/platform/product/relation/create")
    public RestResponse platformProductRelationCreate(@RequestBody PlatformProductRelationCreateInVo inVo) {
        return platformProductRelationService.platformProductRelationCreate(inVo);
    }

    @ApiOperation("平台产品关系删除")
    @DeleteMapping("/platform/product/relation/delete")
    public RestResponse platformProductRelationDelete(@ModelAttribute PlatformProductRelationDeleteInVo inVo) {
        return platformProductRelationService.platformProductRelationDelete(inVo);
    }


}
