package com.system.controller;

import com.system.quartz.model.QuartzJob;
import com.system.serivce.IProductInitConfigService;
import com.system.transfer.init.*;
import com.system.transfer.init.ProductQuartzJobStartInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author Inori
 */
@Api(tags = "产品配置")
@RestController
@RequestMapping("/api")
public class ProductInitConfigController {

    @Autowired
    private IProductInitConfigService productInitConfigService;


    @ApiOperation("产品基础配置")
    @GetMapping("/product/init/common/param")
    public RestResponse productInitCommonParam(@ModelAttribute @Validated ProductInitCommonParamInVo inVo) {
        Map<String, Object> response = productInitConfigService.productInitCommonParam(inVo);
        return RestResponse.success(response);
    }

    @ApiOperation("产品基础配置数据")
    @GetMapping("/product/init/common/param/data")
    public RestResponse productInitCommonParamData(@ModelAttribute @Validated ProductInitCommonParamDataInVo inVo) {
        Map<String, Object> response = productInitConfigService.productInitCommonParamData(inVo);
        return RestResponse.success(response);
    }

    @ApiOperation("产品基础配置创建")
    @PostMapping("/product/init/common/param/create")
    public RestResponse productInitCommonParamCreate(@RequestBody @Validated ProductInitCommonParamStartInVo inVo) {
        return productInitConfigService.productInitCommonParamCreate(inVo);
    }

    @ApiOperation("产品基础配置校验")
    @PostMapping("/product/init/common/param/check")
    public Object productInitCommonParamCheck(@RequestBody @Validated ProductInitCommonParamCheckInVo inVo) {
        return productInitConfigService.productInitCommonParamCheck(inVo);
    }

    @ApiOperation("产品定时任务数据")
    @GetMapping("/product/quartz/job/data")
    public RestResponse productQuartzJobData(@ModelAttribute @Validated ProductQuartzJobDataInVo inVo) {
        QuartzJob quartzJob = productInitConfigService.productQuartzJobData(inVo);
        return RestResponse.success(quartzJob);
    }

    @ApiOperation("产品定时任务配置启动")
    @PostMapping("/product/quartz/job/start")
    public RestResponse productQuartzJobStart(@RequestBody @Validated ProductQuartzJobStartInVo inVo) {
        return productInitConfigService.productQuartzJobStart(inVo);
    }

    @ApiOperation("产品定时任务配置停止")
    @PostMapping("/product/quartz/job/turn/off")
    public RestResponse productQuartzJobTurnOff(@RequestBody @Validated ProductQuartzJobTurnOffInVo inVo) {
        return productInitConfigService.productQuartzJobTurnOff(inVo);
    }


}
