package com.system.controller;

import com.system.serivce.IProductLogService;
import com.system.transfer.product.ProductLogListInVo;
import com.system.transfer.product.ProductLogListOutVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "产品日志")
@RestController
@RequestMapping("/api")
public class ProductLogController {

    @Autowired
    private IProductLogService productLogService;


    @ApiOperation("产品日志列表")
    @GetMapping("/product/log/list")
    public RestResponse productLogList(@ModelAttribute @Validated ProductLogListInVo inVo) {
        ProductLogListOutVo outVo = productLogService.productLogList(inVo);
        return RestResponse.success(outVo);
    }


}
