package com.system.controller;

import com.system.serivce.ISynchronizationOperationService;
import com.system.transfer.response.RestResponse;
import com.system.transfer.synchronization.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "定时任务同步操作")
@RestController
@RequestMapping("/api")
public class SynchronizationOperationController {

    @Autowired
    private ISynchronizationOperationService synchronizationOperationService;


    @ApiOperation("定时任务同步操作列表")
    @GetMapping("/synchronization/operation/list")
    public RestResponse synchronizationOperationList(@ModelAttribute SynchronizationOperationListInVo inVo) {
        SynchronizationOperationListOutVo outVo = synchronizationOperationService.synchronizationOperationList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("定时任务同步操作创建")
    @PostMapping("/synchronization/operation/create")
    public RestResponse synchronizationOperationCreate(@RequestBody SynchronizationOperationCreateInVo inVo) {
        return synchronizationOperationService.synchronizationOperationCreate(inVo);
    }

    @ApiOperation("定时任务同步操作删除")
    @DeleteMapping("/synchronization/operation/delete")
    public RestResponse synchronizationOperationDelete(@ModelAttribute SynchronizationOperationDeleteInVo inVo) {
        return synchronizationOperationService.synchronizationOperationDelete(inVo);
    }


}
