package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.table.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Mapper
public interface DatabaseTableMapper {

    /**
     * 表单表结构列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<TableStructureListOutVoRecords> formTableStructureList(@Param("page") Page<TableStructureListOutVoRecords> page, @Param("inVo") TableStructureListInVo inVo);

    /**
     * 表单详情
     *
     * @param inVo 条件
     * @return 详情
     */
    TableStructureDetailOutVo formTableStructureDetail(TableStructureDetailInVo inVo);

    /**
     * 表单表结构创建
     *
     * @param inVo 条件
     */
    void tableStructureCreate(TableStructureCreateInVo inVo);

    /**
     * 根据ID查询表单表结构
     *
     * @param id ID
     * @return 数据
     */
    TableStructureListOutVoRecords getFormTableStructureById(Integer id);

    /**
     * 根据ID查询表单表结构
     *
     * @param formId 表单标识
     * @return 数据
     */
    TableStructureListOutVoRecords getFormTableStructureByFormId(String formId);

    /**
     * 表单表结构创建
     *
     * @param inVo 条件
     */
    void formTableStructureCreate(TableStructureCreateInVo inVo);

    /**
     * 表单表结构更新
     *
     * @param inVo 条件
     */
    void formTableStructureUpdate(TableStructureCreateInVo inVo);

    /**
     * 表单删除
     *
     * @param inVo 条件
     */
    void formTableStructureDelete(TableStructureDeleteInVo inVo);

    /**
     * 表单数据删除
     *
     * @param inVo 条件
     */
    void formTableStructureDataDelete(TableStructureDataDeleteInVo inVo);

    /**
     * 判断数据库是否存在
     *
     * @param dbTableName 数据库表名称
     * @return 1-存在 0-不存在
     */
    Integer isDatabaseTableDoesItExist(String dbTableName);

    /**
     * 数据库表创建
     *
     * @param inVo        条件
     * @param recordsList 条件
     */
    void databaseTableCreate(@Param("inVo") TableStructureCreateInVo inVo, @Param("recordsList") List<TableStructureCreateInVoRecords> recordsList);

    /**
     * 数据库表删除
     *
     * @param dbTableName 数据库表名称
     */
    void databaseTableDelete(@Param("dbTableName") String dbTableName);

    /**
     * 数据库表创建
     *
     * @param inVo        条件
     * @param recordsList 条件
     */
    void databaseTableCreateByCommonConfig(@Param("inVo") TableStructureCreateInVo inVo, @Param("recordsList") List<TableStructureCreateInVoRecords> recordsList);

    /**
     * 数据库表名称修改
     *
     * @param dbTableName    表名称
     * @param oldDbTableName 原表名称
     */
    void databaseTableNameUpdate(@Param("dbTableName") String dbTableName, @Param("oldDbTableName") String oldDbTableName);

    /**
     * 数据库表注释修改
     *
     * @param dbTableName    表名称
     * @param dbTableComment 表注释
     */
    void databaseTableCommentUpdate(@Param("dbTableName") String dbTableName, @Param("dbTableComment") String dbTableComment);

    /**
     * 新增表结构字段
     *
     * @param records 条件
     */
    void databaseTableFieldCreate(TableStructureCreateInVoRecords records);

    /**
     * 修改表结构字段
     *
     * @param records 条件
     */
    void databaseTableFieldUpdate(TableStructureCreateInVoRecords records);

    /**
     * 删除表结构字段
     *
     * @param records 条件
     */
    void databaseTableFieldDelete(TableStructureCreateInVoRecords records);

    /**
     * 数据库表数据列表
     *
     * @param dbTableName 数据库名称
     * @param dbFiledList 数据库字段列表
     * @param page        分页
     * @return 列表
     */
    List<Map<String, Object>> databaseTableDataList(@Param("dbTableName") String dbTableName, @Param("dbFiledList") List<String> dbFiledList, @Param("page") Page<Map<String, Object>> page);


}
