package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.kingdee.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface KingDeeFieldMappingMapper {

    /**
     * 金蝶字段映射列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<KingDeeFieldMappingListOutVoRecords> kingdeeFieldMappingList(@Param("page") Page<KingDeeFieldMappingListOutVoRecords> page, @Param("inVo") KingDeeFieldMappingListInVo inVo);

    /**
     * 金蝶字段映射列表
     *
     * @param kingdeeCommonConfigIdList 金蝶通用配置ID列表
     * @return 列表
     */
    List<KingDeeFieldMappingListOutVoRecords> getKingdeeFieldMappingListByConfigIdList(@Param("kingdeeCommonConfigIdList") List<Integer> kingdeeCommonConfigIdList);

    /**
     * 金蝶字段映射创建
     *
     * @param inVo 条件
     */
    void kingdeeFieldMappingCreate(KingDeeFieldMappingCreateInVo inVo);

    /**
     * 金蝶字段映射更新
     *
     * @param inVo 条件
     */
    void kingdeeFieldMappingUpdate(KingDeeFieldMappingUpdateInVo inVo);

    /**
     * 金蝶字段映射删除
     *
     * @param inVo 条件
     */
    void kingdeeFieldMappingDelete(KingDeeFieldMappingDeleteInVo inVo);

    /**
     * 金蝶通用配置字段映射删除
     *
     * @param kingdeeCommonConfigId 金蝶通用配置ID
     */
    void kingDeeFieldMappingDeleteByConfigId(Integer kingdeeCommonConfigId);

    /**
     * 金蝶同步操作删除
     *
     * @param kingdeeCommonConfigId 金蝶通用配置ID
     */
    void synchronizationOperationDeleteByConfigId(Integer kingdeeCommonConfigId);


}
