package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.mall.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface MallCommonConfigMapper {

    /**
     * 商城通用配置列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<MallCommonConfigListOutVoRecords> mallCommonConfigList(@Param("page") Page<MallCommonConfigListOutVoRecords> page, @Param("inVo") MallCommonConfigListInVo inVo);

    /**
     * 根据ID查询商城通用配置
     *
     * @param id ID
     * @return 商城通用配置
     */
    MallCommonConfigListOutVoRecords getMallCommonConfigById(Integer id);

    /**
     * 商城通用配置创建
     *
     * @param inVo 条件
     */
    void mallCommonConfigCreate(MallCommonConfigCreateInVo inVo);

    /**
     * 商城通用配置更新
     *
     * @param inVo 条件
     */
    void mallCommonConfigUpdate(MallCommonConfigUpdateInVo inVo);

    /**
     * 商城通用配置删除
     *
     * @param inVo 条件
     */
    void mallCommonConfigDelete(MallCommonConfigDeleteInVo inVo);


}
