package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.mall.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface MallFieldMappingMapper {

    /**
     * 商城字段映射列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<MallFieldMappingListOutVoRecords> mallFieldMappingList(@Param("page") Page<MallFieldMappingListOutVoRecords> page, @Param("inVo") MallFieldMappingListInVo inVo);

    /**
     * 商城字段映射列表
     *
     * @param mallCommonConfigIdList 商城通用配置ID列表
     * @return 列表
     */
    List<MallFieldMappingListOutVoRecords> getMallFieldMappingListByConfigIdList(@Param("mallCommonConfigIdList") List<Integer> mallCommonConfigIdList);


    /**
     * 商城字段映射创建
     *
     * @param inVo 条件
     */
    void mallFieldMappingCreate(MallFieldMappingCreateInVo inVo);

    /**
     * 商城字段映射更新
     *
     * @param inVo 条件
     */
    void mallFieldMappingUpdate(MallFieldMappingUpdateInVo inVo);

    /**
     * 商城字段映射删除
     *
     * @param inVo 条件
     */
    void mallFieldMappingDelete(MallFieldMappingDeleteInVo inVo);


}
