package com.system.dao;

import com.system.transfer.product.PlatformProductRelationCreateInVo;
import com.system.transfer.product.PlatformProductRelationDeleteInVo;
import com.system.transfer.product.PlatformProductRelationListInVo;
import com.system.transfer.product.PlatformProductRelationListOutVoRecords;

import java.util.List;

/**
 * @author Inori
 */
public interface PlatformProductRelationMapper {

    /**
     * 平台产品关系列表
     *
     * @param inVo 条件
     * @return 列表
     */
    List<PlatformProductRelationListOutVoRecords> platformProductRelationList(PlatformProductRelationListInVo inVo);

    /**
     * 根据ID查询平台产品关系
     *
     * @param id ID
     * @return 平台产品关系
     */
    PlatformProductRelationListOutVoRecords getPlatformProductRelationById(Integer id);

    /**
     * 根据前产品编码查询是否存在
     *
     * @param inVo 条件
     * @return 是否存在
     */
    Integer getPlatformProductRelationByCode(PlatformProductRelationCreateInVo inVo);

    /**
     * 平台产品关系创建
     *
     * @param inVo 条件
     */
    void platformProductRelationCreate(PlatformProductRelationCreateInVo inVo);

    /**
     * 平台产品关系删除
     *
     * @param inVo 条件
     */
    void platformProductRelationDelete(PlatformProductRelationDeleteInVo inVo);


}
