package com.system.dao;

import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public interface ProductInitConfigMapper {

    /**
     * 产品基础配置
     *
     * @param dbTableName 数据库名称
     * @param dbFiledList 数据库字段列表
     * @return 基础配置
     */
    Map<String, Object> productInitCommonParam(@Param("dbTableName") String dbTableName, @Param("dbFiledList") List<String> dbFiledList);

    /**
     * 产品基础配置创建
     *
     * @param dbTableName 数据库名称
     * @param data        数据
     */
    void productInitCommonParamCreate(@Param("dbTableName") String dbTableName, @Param("data") Map<String, Object> data);


}
