package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.synchronization.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface SynchronizationOperationMapper {

    /**
     * 定时任务同步操作列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<SynchronizationOperationListOutVoRecords> synchronizationOperationList(@Param("page") Page<SynchronizationOperationListOutVoRecords> page, @Param("inVo") SynchronizationOperationListInVo inVo);

    /**
     * 根据ID查询同步操作
     *
     * @param id ID
     * @return 同步操作
     */
    SynchronizationOperationListOutVoRecords getSynchronizationOperationById(Integer id);

    /**
     * 定时任务同步操作创建
     *
     * @param inVo 条件
     */
    void synchronizationOperationCreate(SynchronizationOperationCreateInVo inVo);

    /**
     * 定时任务同步操作创建
     *
     * @param inVo 条件
     */
    void synchronizationOperationDelete(SynchronizationOperationDeleteInVo inVo);


}
