package com.system.enums;

/**
 * @author Inori
 */
public enum ProductAdapterEnum {

    /**
     * 适配器地址
     */
    KING_DEE_QUARTZ_JOB("kingdee", "http://kingdee-adapter:12001/"),
    MALL_QUARTZ_JOB("mall", "http://mall-adapter:12002/");

    private final String key;

    private final String value;


    ProductAdapterEnum(String key, String value) {
        this.key = key;
        this.value = value;
    }


    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValue(String key) {
        for (ProductAdapterEnum operationEnum : ProductAdapterEnum.values()) {
            if (key.equals(operationEnum.getKey())) {
                return operationEnum.getValue();
            }
        }
        return "";
    }


}
