package com.system.enums;

/**
 * @author Inori
 */
public enum ProductQuartzJobEnum {

    /**
     * 定时任务类别
     */
    KING_DEE_QUARTZ_JOB("kingdee", "com.system.quartz.job.KingDeeSynchronizationJob"),
    MALL_QUARTZ_JOB("mall", "com.system.quartz.job.MallSynchronizationJob");

    private final String key;

    private final String value;


    ProductQuartzJobEnum(String key, String value) {
        this.key = key;
        this.value = value;
    }


    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValue(String key) {
        for (ProductQuartzJobEnum operationEnum : ProductQuartzJobEnum.values()) {
            if (key.equals(operationEnum.getKey())) {
                return operationEnum.getValue();
            }
        }
        return "";
    }


}
