package com.system.serivce;

import com.system.quartz.model.QuartzJob;
import com.system.transfer.init.*;
import com.system.transfer.response.RestResponse;

import java.util.Map;

/**
 * @author Inori
 */
public interface IProductInitConfigService {

    /**
     * 产品基础配置
     *
     * @param inVo 条件
     * @return 结果
     */
    Map<String, Object> productInitCommonParam(ProductInitCommonParamInVo inVo);

    /**
     * 产品基础配置数据
     *
     * @param inVo 条件
     * @return 结果
     */
    Map<String, Object> productInitCommonParamData(ProductInitCommonParamDataInVo inVo);

    /**
     * 商城基础配置创建
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse productInitCommonParamCreate(ProductInitCommonParamStartInVo inVo);

    /**
     * 产品基础配置校验
     *
     * @param inVo 条件
     * @return 结果
     */
    Object productInitCommonParamCheck(ProductInitCommonParamCheckInVo inVo);

    /**
     * 产品定时任务数据
     *
     * @param inVo 条件
     * @return 结果
     */
    QuartzJob productQuartzJobData(ProductQuartzJobDataInVo inVo);

    /**
     * 产品定时任务配置启动
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse productQuartzJobStart(ProductQuartzJobStartInVo inVo);

    /**
     * 产品定时任务配置停止
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse productQuartzJobTurnOff(ProductQuartzJobTurnOffInVo inVo);


}
