package com.system.serivce;

import java.util.Map;

import com.system.quartz.model.QuartzJob;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamCreateInVo;
import com.system.transfer.configure.InitConnectParamOutVo;
import com.system.transfer.response.RestResponse;

/**
 * @author Inori
 */
public interface ISynchronizationService {

    /**
     * 开启同步
     *
     * @return 结果
     */
    RestResponse startSynchronization();

    /**
     * 关闭同步
     *
     * @return 结果
     */
    RestResponse turnOffSynchronization();

    /**
     * 定时同步
     *
     * @return 结果
     */
    QuartzJob synchronizationStatus();

    /**
     * 手动同步
     *
     * @return 结果
     */
    Object manualSynchronization();
    
    /**
     * 手动同步
     * @return
     */
    Object manualSynchronizationByParam(String docType);

    /**
     * 查询金蝶配置
     *
     * @return 金蝶配置
     */
    InitConnectParamOutVo initConnectParam();

    /**
     * 保存金蝶配置
     *
     * @param inVo 条件
     * @return 结果
     */
    RestResponse initConnectParamCreate(InitConnectParamCreateInVo inVo);

    /**
     * 校验金蝶参数
     *
     * @param inVo 条件
     * @return 结果
     */
    Object initConnectParamCheck(InitConnectParamCheckInVo inVo);


}
