package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.*;
import com.system.enums.ProductAdapterEnum;
import com.system.serivce.IDatabaseTableService;
import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import com.system.transfer.kingdee.KingDeeFieldMappingListOutVoRecords;
import com.system.transfer.mall.MallCommonConfigListOutVoRecords;
import com.system.transfer.mall.MallFieldMappingListOutVoRecords;
import com.system.transfer.product.PlatformProductRelationListOutVoRecords;
import com.system.transfer.response.RestResponse;
import com.system.transfer.table.*;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import com.system.utils.TableStructureUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Service
public class DatabaseTableServiceImpl implements IDatabaseTableService {

    @Autowired
    private DatabaseTableMapper databaseTableMapper;

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;

    @Autowired
    private KingDeeFieldMappingMapper kingDeeFieldMappingMapper;

    @Autowired
    private MallCommonConfigMapper mallCommonConfigMapper;

    @Autowired
    private MallFieldMappingMapper mallFieldMappingMapper;

    @Autowired
    private PlatformProductRelationMapper platformProductRelationMapper;


    @Override
    public TableStructureListOutVo formTableStructureList(TableStructureListInVo inVo) {
        Page<TableStructureListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<TableStructureListOutVoRecords> recordsList = databaseTableMapper.formTableStructureList(page, inVo);

        TableStructureListOutVo outVo = new TableStructureListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public TableStructureDetailOutVo formTableStructureDetail(TableStructureDetailInVo inVo) {
        return databaseTableMapper.formTableStructureDetail(inVo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public RestResponse formTableStructureCreate(TableStructureCreateInVo inVo) {
        if (StringUtil.isNotNull(inVo.getData())) {
            inVo.setFormJson(JsonUtil.toString(inVo.getData()));
        }

        TableStructureListOutVoRecords temp00 = databaseTableMapper.getFormTableStructureByFormId(inVo.getFormId());
        if (StringUtil.isNotNull(temp00)) {
            return RestResponse.fail("表单标识已存在");
        }

        TableStructureCreateInVo request = TableStructureUtil.encapsulationInVo(inVo);
        List<TableStructureCreateInVoRecords> recordsList = TableStructureUtil.getFieldList(inVo.getFormJson());
        List<TableStructureCreateInVoRecords> collectList = recordsList.stream().filter(m -> StringUtil.isBlank(m.getDbFieldName()) && StringUtil.isBlank(m.getDbFieldComment())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collectList)) {
            return RestResponse.fail("字段填写缺失");
        }

        if (StringUtil.isNull(inVo.getId())) {
            if (databaseTableMapper.isDatabaseTableDoesItExist(request.getDbTableName()) > 0) {
                return RestResponse.fail("数据库表已存在");
            }

            request.setDbTableComment("'" + request.getDbTableComment() + "'");
            databaseTableMapper.databaseTableCreate(request, recordsList);

            request.setDbTableComment(request.getDbTableComment().replace("'", ""));
            databaseTableMapper.formTableStructureCreate(request);
        } else {
            TableStructureListOutVoRecords result = databaseTableMapper.getFormTableStructureById(request.getId());
            if (!request.getDbTableName().equals(result.getDbTableName())) {
                databaseTableMapper.databaseTableNameUpdate(request.getDbTableName(), result.getDbTableName());
            }
            if (!request.getDbTableComment().equals(result.getDbTableComment())) {
                databaseTableMapper.databaseTableCommentUpdate(request.getDbTableName(), "'" + request.getDbTableComment() + "'");
            }

            List<TableStructureCreateInVoRecords> tempList = TableStructureUtil.getFieldList(result.getFormJson());

            List<TableStructureCreateInVoRecords> deleteList = TableStructureUtil.isCreateOrDelete(tempList, recordsList);
            if (!CollectionUtils.isEmpty(deleteList)) {
                for (TableStructureCreateInVoRecords records : deleteList) {
                    records.setDbTableName(request.getDbTableName());
                    databaseTableMapper.databaseTableFieldDelete(records);
                }
            }

            List<TableStructureCreateInVoRecords> createList = TableStructureUtil.isCreateOrDelete(recordsList, tempList);
            if (!CollectionUtils.isEmpty(createList)) {
                for (TableStructureCreateInVoRecords records : createList) {
                    records.setDbTableName(request.getDbTableName());
                    databaseTableMapper.databaseTableFieldCreate(records);
                }
            }

            List<TableStructureCreateInVoRecords> updateList = TableStructureUtil.isUpdate(recordsList, tempList);
            if (!CollectionUtils.isEmpty(updateList)) {
                for (TableStructureCreateInVoRecords records : updateList) {
                    records.setDbTableName(request.getDbTableName());
                    databaseTableMapper.databaseTableFieldUpdate(records);
                }
            }

            databaseTableMapper.formTableStructureUpdate(request);
        }

        return RestResponse.success();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public RestResponse formTableStructureDelete(TableStructureDeleteInVo inVo) {
        databaseTableMapper.formTableStructureDelete(inVo);
        databaseTableMapper.databaseTableDelete(inVo.getDbTableName());
        return RestResponse.success();
    }

    @Override
    public TableStructureDataOutVo formTableStructureData(TableStructureDataInVo inVo) {
        TableStructureListOutVoRecords records = databaseTableMapper.getFormTableStructureByFormId(inVo.getFormId());

        List<TableStructureDataOutVoRecords> fieldList = TableStructureUtil.getFormFieldList(records.getFormJson());
        List<String> dbFieldName = fieldList.stream().map(TableStructureDataOutVoRecords::getKey).collect(Collectors.toList());

        Page<Map<String, Object>> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<Map<String, Object>> dataList = databaseTableMapper.databaseTableDataList(records.getDbTableName(), dbFieldName, page);

        TableStructureDataOutVo outVo = new TableStructureDataOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setFieldList(fieldList);
        outVo.setDataList(dataList);
        return outVo;
    }

    @Override
    public RestResponse formTableStructureDataDelete(TableStructureDataDeleteInVo inVo) {
        databaseTableMapper.formTableStructureDataDelete(inVo);

        return RestResponse.success();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public RestResponse formTableStructureCommonConfigCreate(TableStructureCommonConfigCreateInVo inVo) {
        PlatformProductRelationListOutVoRecords records = platformProductRelationMapper.getPlatformProductRelationById(inVo.getProductId());

        if (ProductAdapterEnum.KING_DEE_QUARTZ_JOB.getKey().equals(records.getProductBeforeCode())) {
            KingDeeCommonConfigListOutVoRecords temp01 = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getConfigId());
            if (StringUtil.isNull(temp01)) {
                return RestResponse.fail("金蝶通用配置不存在");
            }
            TableStructureListOutVoRecords temp00 = databaseTableMapper.getFormTableStructureByFormId(temp01.getDocType());
            if (StringUtil.isNotNull(temp00)) {
                return RestResponse.fail("表单标识已存在");
            }
            if (databaseTableMapper.isDatabaseTableDoesItExist(temp01.getSFormId().toLowerCase()) > 0) {
                return RestResponse.fail("数据库表已存在");
            }

            List<KingDeeFieldMappingListOutVoRecords> fieldList = kingDeeFieldMappingMapper.getKingdeeFieldMappingListByConfigIdList(Stream.of(temp01.getId()).collect(Collectors.toList()));

            String formJson = TableStructureUtil.getFormGeneratorByKingDee(temp01.getDocType(), temp01.getSFormId(), temp01.getName(), fieldList);
            databaseTableMapper.tableStructureCreate(new TableStructureCreateInVo(temp01.getDocType(), temp01.getSFormId().toLowerCase(), temp01.getName(), formJson));

            TableStructureCreateInVo temp02 = new TableStructureCreateInVo(temp01.getSFormId().toLowerCase(), "'" + temp01.getName() + "'");
            databaseTableMapper.databaseTableCreateByCommonConfig(temp02, TableStructureUtil.getDbTableFiledDataByKingDee(fieldList));
        } else if (ProductAdapterEnum.MALL_QUARTZ_JOB.getKey().equals(records.getProductBeforeCode())) {
            MallCommonConfigListOutVoRecords temp01 = mallCommonConfigMapper.getMallCommonConfigById(inVo.getConfigId());
            if (StringUtil.isNull(temp01)) {
                return RestResponse.fail("商城通用配置不存在");
            }
            TableStructureListOutVoRecords temp00 = databaseTableMapper.getFormTableStructureByFormId(temp01.getDocType());
            if (StringUtil.isNotNull(temp00)) {
                return RestResponse.fail("表单标识已存在");
            }
            if (databaseTableMapper.isDatabaseTableDoesItExist(temp01.getSFormId().toLowerCase()) > 0) {
                return RestResponse.fail("数据库表已存在");
            }

            List<MallFieldMappingListOutVoRecords> fieldList = mallFieldMappingMapper.getMallFieldMappingListByConfigIdList(Stream.of(temp01.getId()).collect(Collectors.toList()));

            String formJson = TableStructureUtil.getFormGeneratorByMall(temp01.getDocType(), temp01.getSFormId(), temp01.getName(), fieldList);
            databaseTableMapper.tableStructureCreate(new TableStructureCreateInVo(temp01.getDocType(), temp01.getSFormId().toLowerCase(), temp01.getName(), formJson));

            TableStructureCreateInVo temp02 = new TableStructureCreateInVo(temp01.getSFormId().toLowerCase(), "'" + temp01.getName() + "'");
            databaseTableMapper.databaseTableCreateByCommonConfig(temp02, TableStructureUtil.getDbTableFiledDataByMall(fieldList));
        }

        return RestResponse.success();
    }


}
