package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.DictItemMapper;
import com.system.serivce.IDictItemService;
import com.system.transfer.configure.DictItemListInVo;
import com.system.transfer.configure.DictItemListOutVo;
import com.system.transfer.configure.DictItemListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class DictItemServiceImpl implements IDictItemService {

    @Autowired
    private DictItemMapper dictItemMapper;


    @Override
    public DictItemListOutVo dictItemList(DictItemListInVo inVo) {
        Page<DictItemListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<DictItemListOutVoRecords> recordsList = dictItemMapper.dictItemList(page, inVo);

        DictItemListOutVo outVo = new DictItemListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }


}
