package com.system.serivce.impl;

import com.system.dao.PlatformProductRelationMapper;
import com.system.serivce.IPlatformProductRelationService;
import com.system.transfer.product.*;
import com.system.transfer.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class IPlatformProductRelationServiceImpl implements IPlatformProductRelationService {

    @Autowired
    private PlatformProductRelationMapper platformProductRelationMapper;


    @Override
    public PlatformProductRelationListOutVo platformProductRelationList(PlatformProductRelationListInVo inVo) {
        List<PlatformProductRelationListOutVoRecords> recordsList = platformProductRelationMapper.platformProductRelationList(inVo);

        PlatformProductRelationListOutVo outVo = new PlatformProductRelationListOutVo();
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse platformProductRelationCreate(PlatformProductRelationCreateInVo inVo) {
        Integer count = platformProductRelationMapper.getPlatformProductRelationByCode(inVo);
        if (count > 0) {
            return RestResponse.fail("产品关系已存在，请重新选择！");
        }
        platformProductRelationMapper.platformProductRelationCreate(inVo);
        return RestResponse.success();
    }

    @Override
    public RestResponse platformProductRelationDelete(PlatformProductRelationDeleteInVo inVo) {
        platformProductRelationMapper.platformProductRelationDelete(inVo);
        return RestResponse.success();
    }


}
