package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.api.CommonHttpApi;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.dao.KingDeeFieldMappingMapper;
import com.system.enums.OperationEnum;
import com.system.serivce.IKingDeeCommonConfigService;
import com.system.serivce.IProductInitConfigService;
import com.system.transfer.init.ProductInitCommonParamDataInVo;
import com.system.transfer.kingdee.*;
import com.system.transfer.response.RestResponse;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class KingDeeCommonConfigServiceImpl implements IKingDeeCommonConfigService {

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;

    @Autowired
    private KingDeeFieldMappingMapper kingDeeFieldMappingMapper;

    @Autowired
    private IProductInitConfigService productInitConfigService;


    @Override
    public KingDeeCommonConfigListOutVo kingDeeCommonConfigList(KingDeeCommonConfigListInVo inVo) {
        Page<KingDeeCommonConfigListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<KingDeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigList(page, inVo);

        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(KingDeeCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<KingDeeFieldMappingListOutVoRecords> tempList = kingDeeFieldMappingMapper.getKingdeeFieldMappingListByConfigIdList(idList);
            for (KingDeeCommonConfigListOutVoRecords records : recordsList) {
                List<KingDeeFieldMappingListOutVoRecords> mappingList = tempList.stream().filter(m -> records.getId().equals(m.getKingdeeCommonConfigId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(mappingList)) {
                    records.setMappingRecords(mappingList);
                }
            }
        }

        KingDeeCommonConfigListOutVo outVo = new KingDeeCommonConfigListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse kingDeeCommonConfigCreate(KingDeeCommonConfigCreateInVo inVo) {
        KingDeeCommonConfigOneInVo temp = new KingDeeCommonConfigOneInVo(inVo.getPlatformProductRelationId(), inVo.getSFormId(), inVo.getDocType(), inVo.getOperation());
        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.kingDeeCommonConfigOne(temp);
        if (StringUtil.isNotNull(records)) {
            return RestResponse.fail("标识为: " + (inVo.getOperation() == 2 ? inVo.getDocType() : inVo.getSFormId()) + " 操作为: " + OperationEnum.getValue(inVo.getOperation()) + " 的配置已存在");
        }

        kingDeeCommonConfigMapper.kingDeeCommonConfigCreate(inVo);

        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("kingdee"));
        CommonHttpApi.commonConfigRefresh(data, inVo.getId(), inVo.getSFormId(), inVo.getDocType(), inVo.getOperation());
        return RestResponse.success();
    }

    @Override
    public RestResponse kingDeeCommonConfigUpdate(KingDeeCommonConfigUpdateInVo inVo) {
        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getId());
        kingDeeCommonConfigMapper.kingDeeCommonConfigUpdate(inVo);

        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("kingdee"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }

    @Override
    public RestResponse kingDeeCommonConfigDelete(KingDeeCommonConfigDeleteInVo inVo) {
        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getId());

        kingDeeCommonConfigMapper.kingDeeCommonConfigDelete(inVo);
        kingDeeFieldMappingMapper.kingDeeFieldMappingDeleteByConfigId(inVo.getId());

        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("kingdee"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }


}
