package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.api.CommonHttpApi;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.dao.KingDeeFieldMappingMapper;
import com.system.serivce.IKingDeeFieldMappingService;
import com.system.serivce.IProductInitConfigService;
import com.system.transfer.init.ProductInitCommonParamDataInVo;
import com.system.transfer.kingdee.*;
import com.system.transfer.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class KingDeeFieldMappingServiceImpl implements IKingDeeFieldMappingService {

    @Autowired
    private KingDeeFieldMappingMapper kingDeeFieldMappingMapper;

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;

    @Autowired
    private IProductInitConfigService productInitConfigService;


    @Override
    public KingDeeFieldMappingListOutVo kingdeeFieldMappingList(KingDeeFieldMappingListInVo inVo) {
        Page<KingDeeFieldMappingListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<KingDeeFieldMappingListOutVoRecords> recordsList = kingDeeFieldMappingMapper.kingdeeFieldMappingList(page, inVo);

        KingDeeFieldMappingListOutVo outVo = new KingDeeFieldMappingListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse kingdeeFieldMappingCreate(KingDeeFieldMappingCreateInVo inVo) {
        kingDeeFieldMappingMapper.kingdeeFieldMappingCreate(inVo);

        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getKingdeeCommonConfigId());
        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("kingdee"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }

    @Override
    public RestResponse kingdeeFieldMappingUpdate(KingDeeFieldMappingUpdateInVo inVo) {
        kingDeeFieldMappingMapper.kingdeeFieldMappingUpdate(inVo);

        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getKingdeeCommonConfigId());
        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("kingdee"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }

    @Override
    public RestResponse kingdeeFieldMappingDelete(KingDeeFieldMappingDeleteInVo inVo) {
        kingDeeFieldMappingMapper.kingdeeFieldMappingDelete(inVo);

        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(inVo.getKingdeeCommonConfigId());
        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("kingdee"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }


}
