package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.KingDeeLogMapper;
import com.system.serivce.IKingDeeLogService;
import com.system.transfer.kingdee.KingDeeLogListInVo;
import com.system.transfer.kingdee.KingDeeLogListOutVo;
import com.system.transfer.kingdee.KingDeeLogListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class KingDeeLogServiceImpl implements IKingDeeLogService {

    @Autowired
    private KingDeeLogMapper kingDeeLogMapper;


    @Override
    public KingDeeLogListOutVo kingDeeLogList(KingDeeLogListInVo inVo) {
        Page<KingDeeLogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<KingDeeLogListOutVoRecords> recordsList = kingDeeLogMapper.kingDeeLogList(page, inVo);

        KingDeeLogListOutVo outVo = new KingDeeLogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }


}
