package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.constants.RsaKeyConstant;
import com.system.dao.LicMapper;
import com.system.scheduler.LicScheduler;
import com.system.serivce.ILicFileService;
import com.system.transfer.configure.LicInfoFileImportInVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.*;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

/**
 * @author Inori
 */
@Service
public class LicFileServiceImpl implements ILicFileService {

    @Autowired
    private RsaKeyConstant rsaKeyConstant;

    @Autowired
    private LicMapper licMapper;

    @Autowired
    private LicScheduler licScheduler;


    @Override
    public RestResponse licInfoFileImport(LicInfoFileImportInVo inVo) {
        String fileName = Objects.requireNonNull(inVo.getFile().getOriginalFilename());
        if (fileName.contains(".") && !fileName.split("\\.")[1].equals(Constants.FILE_FORMAT)) {
            return RestResponse.fail("Lic文件格式错误");
        }

        try {
            String data = FileUtil.read(inVo.getFile().getInputStream());
            String response = RsaUtil.decryptByPublicKey(data, rsaKeyConstant.getPublicKey());
            Map<String, String> map = JsonUtil.toMap(response, String.class, String.class);
            if (CollectionUtils.isEmpty(map) || !map.containsKey(Constants.EFFECTIVE_TIME)) {
                return RestResponse.fail("Lic文件内容错误");
            }


            if (new Date().after(new SimpleDateFormat(Constants.TIME_FORMAT).parse(map.get(Constants.EFFECTIVE_TIME)))) {
                return RestResponse.fail("Lic文件导入时间已过期");
            }

            licMapper.licCipherTextCreateOrUpdate(1, data);
            licScheduler.setLicScheduler(Integer.parseInt(map.get(Constants.VERIFICATION_INTERVAL)));
        } catch (Exception e) {
            e.printStackTrace();
            return RestResponse.fail("Lic文件保存失败");
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse macAddressDetail() {
        try {
            return RestResponse.success(LocalMacUtil.getLocalMac(InetAddress.getLocalHost()));
        } catch (SocketException | UnknownHostException e) {
            e.printStackTrace();
            return RestResponse.fail("获取MAC地址失败");
        }
    }

    @Override
    public RestResponse licInfoFileDownload() {
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream output = null;
        try {
            String json = "{\"macAddress\":\"02-42-AC-13-00-02\",\"effectiveTime\":\"2022-12-02 18:15:00\",\"verificationInterval\":43200}";
            byte[] fileByte = HttpUtil.download("http://127.0.0.1:8090/lic/api/lic/info/file/create", json);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(fileByte);
            bis = new BufferedInputStream(byteInputStream);
            File file = new File("C:\\Users\\Lnori\\Desktop\\lic1.tmp");
            fos = new FileOutputStream(file);
            // 实例化OutputString 对象
            output = new BufferedOutputStream(fos);
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (StringUtil.isNotNull(bis)) {
                try {
                    bis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtil.isNotNull(fos)) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtil.isNotNull(output)) {
                try {
                    output.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return RestResponse.success();
    }


}
