package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.api.CommonHttpApi;
import com.system.dao.MallCommonConfigMapper;
import com.system.dao.MallFieldMappingMapper;
import com.system.serivce.IMallFieldMappingService;
import com.system.serivce.IProductInitConfigService;
import com.system.transfer.init.ProductInitCommonParamDataInVo;
import com.system.transfer.mall.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class MallFieldMappingServiceImpl implements IMallFieldMappingService {

    @Autowired
    private MallFieldMappingMapper mallFieldMappingMapper;

    @Autowired
    private MallCommonConfigMapper mallCommonConfigMapper;

    @Autowired
    private IProductInitConfigService productInitConfigService;


    @Override
    public MallFieldMappingListOutVo mallFieldMappingList(MallFieldMappingListInVo inVo) {
        Page<MallFieldMappingListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<MallFieldMappingListOutVoRecords> recordsList = mallFieldMappingMapper.mallFieldMappingList(page, inVo);

        MallFieldMappingListOutVo outVo = new MallFieldMappingListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public void mallFieldMappingCreate(MallFieldMappingCreateInVo inVo) {
        mallFieldMappingMapper.mallFieldMappingCreate(inVo);

        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(inVo.getMallCommonConfigId());
        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("mall"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
    }

    @Override
    public void mallFieldMappingUpdate(MallFieldMappingUpdateInVo inVo) {
        mallFieldMappingMapper.mallFieldMappingUpdate(inVo);

        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(inVo.getMallCommonConfigId());
        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("mall"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
    }

    @Override
    public void mallFieldMappingDelete(MallFieldMappingDeleteInVo inVo) {
        mallFieldMappingMapper.mallFieldMappingDelete(inVo);

        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(inVo.getMallCommonConfigId());
        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("mall"));
        CommonHttpApi.commonConfigRefresh(data, records.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
    }


}
