package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.api.CommonHttpApi;
import com.system.dao.MallCommonConfigMapper;
import com.system.dao.MallFieldMappingMapper;
import com.system.serivce.IMallCommonConfigService;
import com.system.serivce.IProductInitConfigService;
import com.system.transfer.init.ProductInitCommonParamDataInVo;
import com.system.transfer.mall.*;
import com.system.transfer.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class MallFormConfigServiceImpl implements IMallCommonConfigService {

    @Autowired
    private MallCommonConfigMapper mallCommonConfigMapper;

    @Autowired
    private MallFieldMappingMapper mallFieldMappingMapper;

    @Autowired
    private IProductInitConfigService productInitConfigService;


    @Override
    public MallCommonConfigListOutVo mallCommonConfigList(MallCommonConfigListInVo inVo) {
        Page<MallCommonConfigListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<MallCommonConfigListOutVoRecords> recordsList = mallCommonConfigMapper.mallCommonConfigList(page, inVo);

        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(MallCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<MallFieldMappingListOutVoRecords> tempList = mallFieldMappingMapper.getMallFieldMappingListByConfigIdList(idList);
            for (MallCommonConfigListOutVoRecords records : recordsList) {
                List<MallFieldMappingListOutVoRecords> mappingList = tempList.stream().filter(m -> records.getId().equals(m.getMallCommonConfigId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(mappingList)) {
                    records.setMappingRecords(mappingList);
                }
            }
        }

        MallCommonConfigListOutVo outVo = new MallCommonConfigListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse mallCommonConfigCreate(MallCommonConfigCreateInVo inVo) {
        mallCommonConfigMapper.mallCommonConfigCreate(inVo);

        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("mall"));
        CommonHttpApi.commonConfigRefresh(data, inVo.getId(), inVo.getSFormId(), inVo.getDocType(), inVo.getOperation());
        return RestResponse.success();
    }

    @Override
    public RestResponse mallCommonConfigUpdate(MallCommonConfigUpdateInVo inVo) {
        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(inVo.getId());
        mallCommonConfigMapper.mallCommonConfigUpdate(inVo);

        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("mall"));
        CommonHttpApi.commonConfigRefresh(data, inVo.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }

    @Override
    public RestResponse mallCommonConfigDelete(MallCommonConfigDeleteInVo inVo) {
        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(inVo.getId());
        mallCommonConfigMapper.mallCommonConfigDelete(inVo);

        Map<String, Object> data = productInitConfigService.productInitCommonParamData(new ProductInitCommonParamDataInVo("mall"));
        CommonHttpApi.commonConfigRefresh(data, inVo.getId(), records.getSFormId(), records.getDocType(), records.getOperation());
        return RestResponse.success();
    }


}
