package com.system.serivce.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.system.api.CommonHttpApi;
import com.system.constants.Constants;
import com.system.dao.DatabaseTableMapper;
import com.system.dao.ProductInitConfigMapper;
import com.system.enums.ProductQuartzJobEnum;
import com.system.quartz.model.QuartzJob;
import com.system.quartz.service.IQuartzJobService;
import com.system.quartz.transfer.QuartzJobPauseInVo;
import com.system.quartz.transfer.QuartzJobResumeInVo;
import com.system.serivce.IProductInitConfigService;
import com.system.transfer.init.*;
import com.system.transfer.response.RestResponse;
import com.system.transfer.table.TableStructureDataOutVoRecords;
import com.system.transfer.table.TableStructureListOutVoRecords;
import com.system.utils.JsonUtil;
import com.system.utils.TableStructureUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class ProductInitConfigServiceImpl implements IProductInitConfigService {

    @Autowired
    private ProductInitConfigMapper productInitConfigMapper;

    @Autowired
    private IQuartzJobService quartzJobService;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;


    @Override
    public Map<String, Object> productInitCommonParam(ProductInitCommonParamInVo inVo) {
        TableStructureListOutVoRecords records = databaseTableMapper.getFormTableStructureByFormId(inVo.getCode());

        List<TableStructureDataOutVoRecords> recordsList = TableStructureUtil.getFormFieldList(records.getFormJson());
        List<String> dbFiledList = recordsList.stream().map(TableStructureDataOutVoRecords::getKey).collect(Collectors.toList());

        Map<String, Object> data = productInitConfigMapper.productInitCommonParam(records.getDbTableName(), dbFiledList);
        return TableStructureUtil.encapsulationDefaultValue(records.getFormJson(), data);
    }

    @Override
    public Map<String, Object> productInitCommonParamData(ProductInitCommonParamDataInVo inVo) {
        TableStructureListOutVoRecords records = databaseTableMapper.getFormTableStructureByFormId(inVo.getCode());

        List<TableStructureDataOutVoRecords> recordsList = TableStructureUtil.getFormFieldList(records.getFormJson());
        List<String> dbFiledList = recordsList.stream().map(TableStructureDataOutVoRecords::getKey).collect(Collectors.toList());

        Map<String, Object> response = productInitConfigMapper.productInitCommonParam(records.getDbTableName(), dbFiledList);
        return TableStructureUtil.encapsulationModelValue(records.getFormJson(), response);
    }

    @Override
    public RestResponse productInitCommonParamCreate(ProductInitCommonParamStartInVo inVo) {
        String response = CommonHttpApi.initConnectParamRefresh(inVo.getData());
        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.CODE_NAME)))) {
            return RestResponse.fail("产品配置错误！");
        }

        TableStructureListOutVoRecords records = databaseTableMapper.getFormTableStructureByFormId(inVo.getCode());
        Map<String, Object> data = TableStructureUtil.encapsulationDataModel(records.getFormJson(), inVo.getData());
        data.put("id", 1);
        productInitConfigMapper.productInitCommonParamCreate(records.getDbTableName(), data);
        return RestResponse.success();
    }

    @Override
    public Object productInitCommonParamCheck(ProductInitCommonParamCheckInVo inVo) {
        String response = CommonHttpApi.initConnectParamCheck(inVo.getData());
        return JsonUtil.toMap(response, String.class, Object.class);
    }

    @Override
    public QuartzJob productQuartzJobData(ProductQuartzJobDataInVo inVo) {
        String jobClassName = ProductQuartzJobEnum.getValue(inVo.getCode());
        QueryWrapper<QuartzJob> queryWrapper = new QueryWrapper<QuartzJob>().eq("job_class_name", jobClassName).last("LIMIT 1");
        return quartzJobService.getBaseMapper().selectOne(queryWrapper);
    }

    @Override
    public RestResponse productQuartzJobStart(ProductQuartzJobStartInVo inVo) {
        String jobClassName = ProductQuartzJobEnum.getValue(inVo.getCode());
        return quartzJobService.quartzJobResume(new QuartzJobResumeInVo(jobClassName));
    }

    @Override
    public RestResponse productQuartzJobTurnOff(ProductQuartzJobTurnOffInVo inVo) {
        String jobClassName = ProductQuartzJobEnum.getValue(inVo.getCode());
        return quartzJobService.quartzJobPause(new QuartzJobPauseInVo(jobClassName));
    }


}
