package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.ProductLogMapper;
import com.system.serivce.IProductLogService;
import com.system.transfer.product.ProductLogListInVo;
import com.system.transfer.product.ProductLogListOutVo;
import com.system.transfer.product.ProductLogListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class ProductLogServiceImpl implements IProductLogService {

    @Autowired
    private ProductLogMapper productLogMapper;


    @Override
    public ProductLogListOutVo productLogList(ProductLogListInVo inVo) {
        Page<ProductLogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<ProductLogListOutVoRecords> recordsList = productLogMapper.productLogList(page, inVo);

        ProductLogListOutVo outVo = new ProductLogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }


}
