package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.api.CommonHttpApi;
import com.system.dao.PlatformProductRelationMapper;
import com.system.dao.SynchronizationOperationMapper;
import com.system.enums.ProductQuartzJobEnum;
import com.system.serivce.ISynchronizationOperationService;
import com.system.transfer.product.PlatformProductRelationListOutVoRecords;
import com.system.transfer.response.RestResponse;
import com.system.transfer.synchronization.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class SynchronizationOperationServiceImpl implements ISynchronizationOperationService {

    @Autowired
    private SynchronizationOperationMapper synchronizationOperationMapper;

    @Autowired
    private PlatformProductRelationMapper platformProductRelationMapper;


    @Override
    public SynchronizationOperationListOutVo synchronizationOperationList(SynchronizationOperationListInVo inVo) {
        Page<SynchronizationOperationListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<SynchronizationOperationListOutVoRecords> recordsList = synchronizationOperationMapper.synchronizationOperationList(page, inVo);

        SynchronizationOperationListOutVo outVo = new SynchronizationOperationListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse synchronizationOperationCreate(SynchronizationOperationCreateInVo inVo) {
        PlatformProductRelationListOutVoRecords temp = platformProductRelationMapper.getPlatformProductRelationById(inVo.getPlatformProductRelationId());
        inVo.setJobClassName(ProductQuartzJobEnum.getValue(temp.getProductBeforeCode()));
        synchronizationOperationMapper.synchronizationOperationCreate(inVo);

        CommonHttpApi.synchronizationOperationRefresh(temp.getProductAfterCode(), inVo.getId());
        return RestResponse.success();
    }

    @Override
    public RestResponse synchronizationOperationDelete(SynchronizationOperationDeleteInVo inVo) {
        SynchronizationOperationListOutVoRecords temp = synchronizationOperationMapper.getSynchronizationOperationById(inVo.getId());
        synchronizationOperationMapper.synchronizationOperationDelete(inVo);

        PlatformProductRelationListOutVoRecords records = platformProductRelationMapper.getPlatformProductRelationById(temp.getPlatformProductRelationId());
        CommonHttpApi.synchronizationOperationRefresh(records.getProductAfterCode(), inVo.getId());
        return RestResponse.success();
    }


}
