package com.system.serivce.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.system.constants.Constants;
import com.system.dao.InitConnectParamMapper;
import com.system.model.InitConnectParam;
import com.system.quartz.job.KingDeeSynchronizationJob;
import com.system.quartz.model.QuartzJob;
import com.system.quartz.service.IQuartzJobService;
import com.system.quartz.transfer.QuartzJobPauseInVo;
import com.system.quartz.transfer.QuartzJobResumeInVo;
import com.system.serivce.ISynchronizationService;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamCreateInVo;
import com.system.transfer.configure.InitConnectParamOutVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class SynchronizationServiceImpl implements ISynchronizationService {

    @Autowired
    private InitConnectParamMapper initConnectParamMapper;

    @Autowired
    private IQuartzJobService quartzJobService;


    @Override
    public RestResponse startSynchronization() {
        InitConnectParamOutVo outVo = initConnectParamMapper.initConnectParam();
        if (StringUtil.isNull(outVo)) {
            return RestResponse.fail("请先配置金蝶相关参数！");
        }

        QuartzJob quartzJob = quartzJobService.getBaseMapper().selectOne(new QueryWrapper<QuartzJob>().eq("job_class_name", KingDeeSynchronizationJob.class.getName()).last("LIMIT 1"));

        if (StringUtil.isNotNull(quartzJob)) {
            if (quartzJob.getStatus() == 0) {
                quartzJobService.quartzJobResume(new QuartzJobResumeInVo(quartzJob.getJobClassName()));
                return RestResponse.success();
            }
        } else {
            return RestResponse.fail("自动同步定时任务不存在！");
        }

        return RestResponse.fail("自动同步已经启动，请勿重复启动！");
    }

    @Override
    public RestResponse turnOffSynchronization() {
        InitConnectParamOutVo outVo = initConnectParamMapper.initConnectParam();
        if (StringUtil.isNull(outVo)) {
            return RestResponse.fail("请先配置金蝶相关参数！");
        }

        QuartzJob quartzJob = quartzJobService.getBaseMapper().selectOne(new QueryWrapper<QuartzJob>().eq("job_class_name", KingDeeSynchronizationJob.class.getName()).last("LIMIT 1"));

        if (StringUtil.isNotNull(quartzJob)) {
            if (quartzJob.getStatus() == 1) {
                quartzJobService.quartzJobPause(new QuartzJobPauseInVo(quartzJob.getJobClassName()));
                return RestResponse.success();
            }
        } else {
            return RestResponse.fail("自动同步定时任务不存在！");
        }

        return RestResponse.fail("自动同步已经关闭，请勿重复关闭！");
    }

    @Override
    public QuartzJob synchronizationStatus() {
        return quartzJobService.getBaseMapper().selectOne(new QueryWrapper<QuartzJob>().eq("job_class_name", KingDeeSynchronizationJob.class.getName()).last("LIMIT 1"));
    }

    @Override
    public Object manualSynchronization() {
        InitConnectParamOutVo outVo = initConnectParamMapper.initConnectParam();
        if (StringUtil.isNull(outVo)) {
            return RestResponse.fail("请先配置金蝶相关参数！");
        }

        String result = HttpUtil.httpGet("http://kingdee-adapter:12001/kingdee/api/kingdee/manual/synchronization").getBody();
        return JsonUtil.toMap(result, String.class, Object.class);
    }

    @Override
    public InitConnectParamOutVo initConnectParam() {
        return initConnectParamMapper.initConnectParam();
    }

    @Override
    public RestResponse initConnectParamCreate(InitConnectParamCreateInVo inVo) {
        QuartzJob quartzJob = quartzJobService.getBaseMapper().selectOne(new QueryWrapper<QuartzJob>().eq("job_class_name", KingDeeSynchronizationJob.class.getName()).last("LIMIT 1"));

        if (StringUtil.isNotNull(quartzJob)) {
            if (quartzJob.getStatus() == 1) {
                return RestResponse.fail("请先关闭同步再保存!");
            }
        } else {
            return RestResponse.fail("自动同步定时任务不存在！");
        }

        try {
            String result = HttpUtil.httpPost("http://kingdee-adapter:12001/kingdee/api/init/connect/param/create", JsonUtil.toString(inVo)).getBody();
            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.CODE_NAME)))) {
                return RestResponse.fail("金蝶登陆失败！");
            }
        } catch (Exception e) {
            return RestResponse.fail("金蝶登陆失败！");
        }

        InitConnectParam initConnectParam = new InitConnectParam();
        initConnectParam.setId(1);
        initConnectParam.setK3CloudUrl(inVo.getK3CloudUrl());
        initConnectParam.setDbid(inVo.getDbid());
        initConnectParam.setLang(inVo.getLang());
        initConnectParam.setUid(inVo.getUid());
        initConnectParam.setPwd(inVo.getPwd());
        initConnectParam.setThirdPartyUrl(inVo.getThirdPartyUrl());
        initConnectParam.setDuration(inVo.getDuration());
        initConnectParamMapper.initConnectParamCreateOrUpdate(initConnectParam);

        String cron = "0 */" + inVo.getDuration() + "  * * * ?";
        if (!cron.equals(quartzJob.getCronExpression())) {
            quartzJob.setCronExpression(cron);
            quartzJobService.getBaseMapper().updateById(quartzJob);

            quartzJobService.quartzJobResume(new QuartzJobResumeInVo(quartzJob.getJobClassName()));
        }

        return RestResponse.success();
    }

    @Override
    public Object initConnectParamCheck(InitConnectParamCheckInVo inVo) {
        try {
            String result = HttpUtil.httpPost("http://kingdee-adapter:12001/kingdee/api/init/connect/param/check", JsonUtil.toString(inVo)).getBody();
            return JsonUtil.toMap(result, String.class, Object.class);
        } catch (Exception e) {
            return RestResponse.fail("操作失败，金蝶云登陆失败");
        }
    }

	@Override
	public Object manualSynchronizationByParam(String docType) {
		// TODO Auto-generated method stub
        try {
        	Map<String, String> docParam = new HashMap<String, String>();
        	docParam.put("docType", docType);
            String result = HttpUtil.httpPost("http://kingdee-adapter:12001/kingdee/api/kingdee/manual/synchronizationByParam",  JsonUtil.toString(docParam)).getBody();
            return JsonUtil.toMap(result, String.class, Object.class);
        } catch (Exception e) {
            return RestResponse.fail("操作失败，手动执行失败");
        }
	}


}
