package com.system.transfer.kingdee;

import com.system.utils.StringUtil;

/**
 * @author Inori
 */
public class KingDeeCommonConfigListInVo {

    /**
     * 平台产品关系id
     */
    private Integer platformProductRelationId;


    /**
     * 日志名称
     */
    private String name;


    /**
     * 操作(1-查询 2-创建/更新 3-同步)
     */
    private Integer operation;

    /**
     * 排序
     */
    private Integer paiXu;


    /**
     * 页码
     */
    private Integer pageNo;


    /**
     * 每页数量
     */
    private Integer pageSize;




    private static final Integer DEFAULT_PAGE_NO = 1;
    private static final Integer DEFAULT_PAGE_SIZE = 20;


    public KingDeeCommonConfigListInVo() {
    }


    public Integer getPlatformProductRelationId() {
        return platformProductRelationId;
    }

    public void setPlatformProductRelationId(Integer platformProductRelationId) {
        this.platformProductRelationId = platformProductRelationId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOperation() {
        return operation;
    }

    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    public Integer getPageNo() {
        if (StringUtil.isNull(pageNo) || pageNo == -1) {
            return DEFAULT_PAGE_NO;
        }
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        if (StringUtil.isNull(pageSize) || pageSize == -1) {
            return DEFAULT_PAGE_SIZE;
        }
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPaiXu() {
        return paiXu;
    }

    public void setPaiXu(Integer paiXu) {
        this.paiXu = paiXu;
    }


}
