package com.system.kingdee;

import com.system.api.KingDeeApi;
import com.system.constants.KingDeeCommonSyncConstants;
import com.system.utils.KingDeeUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonGetApi {

    @Autowired
    private KingDeeApi kingDeeApi;


    public List<Map<String, Object>> getKingDeeData(Map<String, String> config, String queueId, List<Map<String, String>> fieldList, Map<String, String> where) {
        Map<String, String> key = KingDeeCommonSyncConstants.encapsulationKingDeeField(fieldList);
        List<List<Object>> result = kingDeeApi.getKingDeeData(config, queueId, key, where);
        return encapsulationIms(result, fieldList, config.get("mesEntryName"));
    }

    /**
     * 封装第三方字段
     */
    private List<Map<String, Object>> encapsulationIms(List<List<Object>> list, List<Map<String, String>> fieldList, String mesEntryName) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            String errorName = "Errors";
            if (!list.get(0).get(0).toString().contains(errorName)) {
                Map<String, Object> map = new HashMap<>(fieldList.size());
                List<Map<String, Object>> tempList = new ArrayList<>();

                KingDeeCommonSyncConstants.encapsulationThirdPartyField(list, fieldList, map, tempList);

                if (StringUtil.isNotBlank(mesEntryName)) {
                    map.put(mesEntryName, tempList);
                } else if (!CollectionUtils.isEmpty(tempList)) {
                    map.put("children", tempList);
                }
                result.add(map);
            } else {
                //如果有错误信息则返回
                String message = KingDeeUtil.getMessage(list.get(0).get(0));

                Map<String, Object> resultMap = new HashMap<>(1);
                resultMap.put("false", message);
                result.add(resultMap);
            }
        }
        return result;
    }


}
