package com.system.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

/**
 * @author Inori
 */
public class SerializerProxy {

    public Object deserialize(String content, Class<?> type) {
        if (content != null && content.length() != 0) {
            return "java.lang.string".equalsIgnoreCase(type.getName()) ? content : this.toDeserialize(content, type);
        } else if (!type.isPrimitive()) {
            return type;
        } else {
            return "java.lang.String".equalsIgnoreCase(type.getName()) ? content : null;
        }
    }

    public Object toDeserialize(String content, Class<?> type) {
        ObjectMapper mapper = new ObjectMapper();

        try {
            return mapper.readValue(content, type);
        } catch (IOException var6) {
            var6.printStackTrace();
        }

        return null;
    }


}