package com.system.service.impl;

import com.system.api.KingDeeApi;
import com.system.api.KingDeeK3CloudApi;
import com.system.constants.*;
import com.system.model.InitConnectParam;
import com.system.service.IKingDeeSyncConfigService;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamRefreshInVo;
import com.system.transfer.configure.CommonConfigRefreshInVo;
import com.system.transfer.configure.SynchronizationOperationRefreshInVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @author Inori
 */
@Service
public class KingDeeSyncConfigServiceImpl implements IKingDeeSyncConfigService {

    @Autowired
    private KingDeeApi kingDeeApi;

    @Autowired
    private KingDeeCommonPushConstants kingDeeCommonPushConstants;

    @Autowired
    private KingDeeCommonSyncConstants kingDeeCommonSyncConstants;

    @Autowired
    private SynchronizationOperationConstants synchronizationOperationConstants;

    @Autowired
    private KingDeeCommonGetConstants kingDeeCommonGetConstants;


    @Override
    public RestResponse initConnectParamRefresh(InitConnectParamRefreshInVo inVo) {
        KingDeeK3CloudApi kingDeeK3CloudApi = new KingDeeK3CloudApi(inVo.getK3CloudUrl());
        Boolean flag;
        try {
            flag = kingDeeK3CloudApi.login(inVo.getDbid(), inVo.getUid(), inVo.getPwd(), inVo.getLang());
        } catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }

        kingDeeApi.setFlag(flag);
        kingDeeApi.setKingDeeK3CloudApi(kingDeeK3CloudApi);
        kingDeeApi.setReceiveAddress(inVo.getReceiveAddress());

        if (!flag) {
            return RestResponse.fail("参数错误，金蝶登陆失败！");
        }

        InitConnectParam initConnectParam = new InitConnectParam();
        initConnectParam.setId(1);
        initConnectParam.setK3CloudUrl(inVo.getK3CloudUrl());
        initConnectParam.setDbid(inVo.getDbid());
        initConnectParam.setLang(inVo.getLang());
        initConnectParam.setUid(inVo.getUid());
        initConnectParam.setPwd(inVo.getPwd());
        initConnectParam.setReceiveAddress(inVo.getReceiveAddress());
        initConnectParam.setAdapterAddress(inVo.getAdapterAddress());
        kingDeeApi.setInitConnectParam(initConnectParam);

        return RestResponse.success();
    }

    @Override
    public RestResponse initConnectParamCheck(InitConnectParamCheckInVo inVo) {
        KingDeeK3CloudApi kingDeeK3CloudApi = kingDeeApi.getKingDeeK3CloudApi();
        boolean flag = false;
        try {
            kingDeeK3CloudApi.setServerUrl(inVo.getK3CloudUrl());
            Object[] data = new Object[]{inVo.getDbid(), inVo.getUid(), inVo.getPwd(), inVo.getLang()};
            String result = kingDeeK3CloudApi.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", data, String.class);

            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (!CollectionUtils.isEmpty(map)) {
                flag = map.containsKey(KingDeeConstants.LOGIN_RESULT_TYPE) && Constants.ONE.equals(Integer.parseInt(String.valueOf(map.get(KingDeeConstants.LOGIN_RESULT_TYPE))));
            }
        } catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }

        if (flag) {
            return RestResponse.success("参数正确，金蝶云登陆成功");
        } else {
            return RestResponse.fail("参数错误，金蝶云登陆失败");
        }
    }

    @Override
    public void commonConfigRefresh(CommonConfigRefreshInVo inVo) {
        if (Constants.TWO.equals(inVo.getOperation())) {
            kingDeeCommonPushConstants.refresh(inVo.getId(), inVo.getDocType());
        } else {
            kingDeeCommonSyncConstants.refresh(inVo.getId(), inVo.getSFormId());
            kingDeeCommonGetConstants.refresh(inVo.getId(), inVo.getDocType());
        }
    }

    @Override
    public void synchronizationOperationRefresh(SynchronizationOperationRefreshInVo inVo) {
        synchronizationOperationConstants.refresh(inVo.getId());
    }


}
