package com.system.utils;

import org.springframework.util.CollectionUtils;

import com.system.constants.KingDeeConstants;

import java.util.*;

/**
 * @author Inori
 */
public class PushResultUtil {

    public static Object encapsulationTo(String code, String message, List<Map<String, Object>> list) {
        Map<String, Object> result = new LinkedHashMap<>();
        result.put("resultCode", code);
        result.put("resultMsg", message);
        if (!CollectionUtils.isEmpty(list)) {
            List<Map<String, Object>> tempList = new ArrayList<>();
            for (Map<String, Object> temp : list) {
                Map<String, Object> map = new HashMap<>();
                map.put("po_code", temp.get("code"));
                map.put("Msg", temp.get("msg"));
                tempList.add(map);
            }
            result.put("resultData", tempList);
        } else {
            result.put("resultData", list);
        }
        return result;
    }

    public static Object encapsulationsTo(String code, String message, List<List<Map<String, Object>>> list, List<Map<String, Object>> results) {
        Map<String, Object> result = new LinkedHashMap<>();
        result.put("resultCode", code);
        result.put("resultMsg", message);
        for(Map<String, Object> curResult:results)
        {
            if (!CollectionUtils.isEmpty(curResult) && !KingDeeConstants.SUCCESS_CODE.equals(curResult.get(KingDeeConstants.CODE_NAME))) {
                result.put("resultCode", KingDeeConstants.ERROR_CODE);
                result.put("resultMsg", "操作失败! " + StringUtil.replaceBlank((String) curResult.get("resultMsg")));
            } else if (CollectionUtils.isEmpty(curResult)) {
                result.put("resultCode", KingDeeConstants.ERROR_CODE);
                result.put("resultMsg", "操作失败! " + StringUtil.replaceBlank((String) "操作失败! " + StringUtil.replaceBlank(JsonUtil.toString(curResult))));
            }
        }
        
        if (!CollectionUtils.isEmpty(list)) {
            List<Map<String, Object>> tempList = new ArrayList<>();
            for (List<Map<String, Object>> temps : list) {

            	for(Map<String, Object> temp:temps)
            	{
	                Map<String, Object> map = new HashMap<>();
	                map.put("po_code", temp.get("code"));
	                map.put("Msg", temp.get("msg"));
	                tempList.add(map);
            	}
            }
            result.put("resultData", tempList);
        } else {
            result.put("resultData", list);
        }
        return result;
    }

}
