package com.system.controller;

import com.system.service.IKingDeeSyncConfigService;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamRefreshInVo;
import com.system.transfer.configure.CommonConfigRefreshInVo;
import com.system.transfer.configure.SynchronizationOperationRefreshInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "金蝶同步配置相关")
@RestController
@RequestMapping("/api")
public class KingDeeSyncConfigController {

    @Autowired
    private IKingDeeSyncConfigService kingDeeSyncConfigService;


    @ApiOperation("金蝶配置刷新")
    @PostMapping("/init/connect/param/refresh")
    public RestResponse initConnectParamRefresh(@RequestBody @Validated InitConnectParamRefreshInVo inVo) {
        return kingDeeSyncConfigService.initConnectParamRefresh(inVo);
    }

    @ApiOperation("校验金蝶参数")
    @PostMapping("/init/connect/param/check")
    public RestResponse initConnectParamCheck(@RequestBody @Validated InitConnectParamCheckInVo inVo) {
        return kingDeeSyncConfigService.initConnectParamCheck(inVo);
    }

    @ApiOperation("金蝶配置刷新")
    @PostMapping("/common/config/refresh")
    public RestResponse kingDeeCommonConfigRefresh(@RequestBody CommonConfigRefreshInVo inVo) {
        kingDeeSyncConfigService.commonConfigRefresh(inVo);
        return RestResponse.success();
    }

    @ApiOperation("同步操作刷新")
    @PostMapping("/synchronization/operation/refresh")
    public RestResponse kingDeeSynchronizationOperationRefresh(@RequestBody SynchronizationOperationRefreshInVo inVo) {
        kingDeeSyncConfigService.synchronizationOperationRefresh(inVo);
        return RestResponse.success();
    }


}
